/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.status.instance;

import java.io.Serializable;

public class InstanceHealth
implements Serializable {
    private int queuedCount;
    private double queuedContentSize;
    private boolean hasBulletins;
    private int activeThreads;

    public int getQueuedCount() {
        return this.queuedCount;
    }

    public void setQueuedCount(int queuedCount) {
        this.queuedCount = queuedCount;
    }

    public double getQueuedContentSize() {
        return this.queuedContentSize;
    }

    public void setQueuedContentSize(double queuedContentSize) {
        this.queuedContentSize = queuedContentSize;
    }

    public boolean isHasBulletins() {
        return this.hasBulletins;
    }

    public void setHasBulletins(boolean hasBulletins) {
        this.hasBulletins = hasBulletins;
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    public void setActiveThreads(int activeThreads) {
        this.activeThreads = activeThreads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceHealth that = (InstanceHealth)o;
        if (this.getQueuedCount() != that.getQueuedCount()) {
            return false;
        }
        if (Double.compare(that.getQueuedContentSize(), this.getQueuedContentSize()) != 0) {
            return false;
        }
        if (this.isHasBulletins() != that.isHasBulletins()) {
            return false;
        }
        return this.activeThreads == that.activeThreads;
    }

    public int hashCode() {
        int result = this.getQueuedCount();
        long temp = Double.doubleToLongBits(this.getQueuedContentSize());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isHasBulletins() ? 1 : 0);
        result = 31 * result + this.activeThreads;
        return result;
    }

    public String toString() {
        return "{queuedCount=" + this.queuedCount + ", queuedContentSize=" + this.queuedContentSize + ", hasBulletins=" + this.hasBulletins + ", activeThreads=" + this.activeThreads + "}";
    }
}

