/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import jakarta.faces.view.facelets.FaceletCache;
import jakarta.faces.view.facelets.FaceletException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.impl.DefaultFacelet;

class FaceletCacheImpl
extends FaceletCache<DefaultFacelet> {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    private Map<String, DefaultFacelet> _facelets;
    private Map<String, DefaultFacelet> _viewMetadataFacelets;
    private long _refreshPeriod;

    FaceletCacheImpl(long refreshPeriod) {
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        this._facelets = new HashMap<String, DefaultFacelet>();
        this._viewMetadataFacelets = new HashMap<String, DefaultFacelet>();
    }

    @Override
    public DefaultFacelet getFacelet(URL url) throws IOException {
        Assert.notNull(url, "url");
        String key = url.toString();
        DefaultFacelet f = this._facelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)this.getMemberFactory().newInstance(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._facelets);
                newLoc.put(key, f);
                this._facelets = newLoc;
            }
        }
        return f;
    }

    @Override
    public boolean isFaceletCached(URL url) {
        return this._facelets.containsKey(url.toString());
    }

    @Override
    public DefaultFacelet getViewMetadataFacelet(URL url) throws IOException {
        Assert.notNull(url, "url");
        String key = url.toString();
        DefaultFacelet f = this._viewMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)this.getMetadataMemberFactory().newInstance(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._viewMetadataFacelets);
                newLoc.put(key, f);
                this._viewMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    @Override
    public boolean isViewMetadataFaceletCached(URL url) {
        return this._viewMetadataFacelets.containsKey(url.toString());
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                long lastModified = ResourceLoaderUtils.getResourceLastModified(facelet.getSource());
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
            }
        }
        return false;
    }
}

