/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.common.io;

import java.io.IOException;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;

public class EndlessWriteFuture
implements IoWriteFuture {
    public static final EndlessWriteFuture INSTANCE = new EndlessWriteFuture();

    public IoWriteFuture verify(long timeoutMillis, CancelOption ... options) throws IOException {
        this.await(timeoutMillis);
        return null;
    }

    public boolean isDone() {
        return false;
    }

    public Object getId() {
        return "ENDLESS";
    }

    public boolean awaitUninterruptibly(long timeoutMillis, CancelOption ... options) {
        try {
            Thread.sleep(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public boolean await(long timeoutMillis, CancelOption ... options) throws IOException {
        return this.awaitUninterruptibly(timeoutMillis);
    }

    public IoWriteFuture removeListener(SshFutureListener<IoWriteFuture> listener) {
        return this;
    }

    public IoWriteFuture addListener(SshFutureListener<IoWriteFuture> listener) {
        return this;
    }

    public boolean isWritten() {
        return false;
    }

    public Throwable getException() {
        return null;
    }
}

