/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import org.apache.ftpserver.ftplet.FtpRequest;

public class DefaultFtpRequest
implements FtpRequest {
    private final String line;
    private final String command;
    private final String argument;
    private final long receivedTime = System.currentTimeMillis();

    public DefaultFtpRequest(String requestLine) {
        this.line = requestLine.trim();
        int spaceIndex = this.line.indexOf(32);
        this.command = this.parseCmd(this.line, spaceIndex);
        this.argument = this.parseArg(this.line, spaceIndex);
    }

    private String parseCmd(String lineToParse, int spaceIndex) {
        String cmd = null;
        cmd = spaceIndex != -1 ? this.line.substring(0, spaceIndex) : this.line;
        if ((cmd = cmd.toUpperCase()).length() > 0 && cmd.charAt(0) == 'X') {
            cmd = cmd.substring(1);
        }
        return cmd;
    }

    private String parseArg(String lineToParse, int spaceIndex) {
        String arg = null;
        if (spaceIndex != -1 && (arg = this.line.substring(spaceIndex + 1)).isEmpty()) {
            arg = null;
        }
        return arg;
    }

    public String getCommand() {
        return this.command;
    }

    public String getArgument() {
        return this.argument;
    }

    public String getRequestLine() {
        return this.line;
    }

    public boolean hasArgument() {
        return this.argument != null;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public String toString() {
        return this.line;
    }
}

