/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxws.handler.DelegatingHandlerChainBuilder;
import org.apache.cxf.jaxws.handler.HandlerChainBuilder;
import org.apache.cxf.jaxws.handler.JakartaeeHandlerChainBuilder;
import org.apache.cxf.jaxws.handler.JavaeeHandlerChainBuilder;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnotationHandlerChainBuilder
extends HandlerChainBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationHandlerChainBuilder.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public AnnotationHandlerChainBuilder() {
    }

    public AnnotationHandlerChainBuilder(Bus bus) {
        super(bus);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz, List<Handler> existingHandlers, QName portQName, QName serviceQName, String bindingID) {
        List<Handler> chain;
        LOG.fine("building handler chain");
        HandlerChainAnnotation hcAnn = this.findHandlerChainAnnotation(clz, true);
        if (hcAnn == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no HandlerChain annotation on " + clz);
            }
            chain = new ArrayList<Handler>();
        } else {
            hcAnn.validate();
            try {
                URL handlerFileURL = this.resolveHandlerChainFile(clz, hcAnn.getFileName());
                if (handlerFileURL == null) {
                    throw new WebServiceException(new Message("HANDLER_CFG_FILE_NOT_FOUND_EXC", BUNDLE, new Object[]{hcAnn.getFileName()}).toString());
                }
                Document doc = StaxUtils.read((InputStream)handlerFileURL.openStream());
                Element el = doc.getDocumentElement();
                boolean isJavaEENamespace = "http://java.sun.com/xml/ns/javaee".equals(el.getNamespaceURI());
                boolean isJakartaEENamespace = "https://jakarta.ee/xml/ns/jakartaee".equals(el.getNamespaceURI());
                if (!isJavaEENamespace && !isJakartaEENamespace) {
                    throw new WebServiceException(BundleUtils.getFormattedString((ResourceBundle)BUNDLE, (String)"NOT_VALID_NAMESPACE", (Object[])new Object[]{el.getNamespaceURI()}));
                }
                ClassLoader classLoader = AnnotationHandlerChainBuilder.getClassLoader(clz);
                DelegatingHandlerChainBuilder delegate = ht -> this.buildHandlerChain(ht, classLoader);
                chain = isJavaEENamespace ? new JavaeeHandlerChainBuilder(BUNDLE, handlerFileURL, delegate).build(el, portQName, serviceQName, bindingID) : new JakartaeeHandlerChainBuilder(BUNDLE, handlerFileURL, delegate).build(el, portQName, serviceQName, bindingID);
            }
            catch (WebServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebServiceException(BUNDLE.getString("CHAIN_NOT_SPECIFIED_EXC"), (Throwable)e);
            }
        }
        assert (chain != null);
        if (existingHandlers != null) {
            chain.addAll(existingHandlers);
        }
        return this.sortHandlers(chain);
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz, QName portQName, QName serviceQName, String bindingID) {
        return this.buildHandlerChainFromClass(clz, null, portQName, serviceQName, bindingID);
    }

    protected URL resolveHandlerChainAnnotationFile(Class<?> clazz, String name) {
        return clazz.getResource(name);
    }

    private HandlerChainAnnotation findHandlerChainAnnotation(Class<?> clz, boolean searchSEI) {
        if (clz == null) {
            return null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Checking for HandlerChain annotation on " + clz.getName());
        }
        HandlerChainAnnotation hcAnn = null;
        HandlerChain ann = clz.getAnnotation(HandlerChain.class);
        if (ann == null) {
            WebService ws;
            if (searchSEI && (ws = clz.getAnnotation(WebService.class)) != null && !StringUtils.isEmpty((String)ws.endpointInterface())) {
                Class seiClass;
                String seiClassName = ws.endpointInterface().trim();
                try {
                    seiClass = ClassLoaderUtils.loadClass((String)seiClassName, clz);
                }
                catch (ClassNotFoundException e) {
                    throw new WebServiceException(BUNDLE.getString("SEI_LOAD_FAILURE_EXC"), (Throwable)e);
                }
                hcAnn = this.findHandlerChainAnnotation(seiClass, false);
            }
            if (hcAnn == null) {
                for (Class<?> iface : clz.getInterfaces()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Checking for HandlerChain annotation on " + iface.getName());
                    }
                    if ((ann = iface.getAnnotation(HandlerChain.class)) == null) continue;
                    hcAnn = new HandlerChainAnnotation(ann, iface);
                    break;
                }
                if (hcAnn == null) {
                    hcAnn = this.findHandlerChainAnnotation(clz.getSuperclass(), false);
                }
            }
        } else {
            hcAnn = new HandlerChainAnnotation(ann, clz);
        }
        return hcAnn;
    }

    static class HandlerChainAnnotation {
        private final Class<?> declaringClass;
        private final HandlerChain ann;

        HandlerChainAnnotation(HandlerChain hc, Class<?> clz) {
            this.ann = hc;
            this.declaringClass = clz;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public String getFileName() {
            return this.ann.file();
        }

        public void validate() {
            if (null == this.ann.file() || "".equals(this.ann.file())) {
                throw new WebServiceException(BUNDLE.getString("ANNOTATION_WITHOUT_URL_EXC"));
            }
        }

        public String toString() {
            return "[" + this.declaringClass + "," + this.ann + "]";
        }
    }
}

