/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;

public class CmisExtensionElementImpl
implements CmisExtensionElement {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String namespace;
    private final String value;
    private Map<String, String> attributes;
    private final List<CmisExtensionElement> children;

    public CmisExtensionElementImpl(String namespace, String name, Map<String, String> attributes, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name must set!");
        }
        this.name = name;
        this.namespace = namespace;
        this.value = value;
        this.children = null;
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : null;
    }

    public CmisExtensionElementImpl(String namespace, String name, Map<String, String> attributes, List<CmisExtensionElement> children) {
        if (name == null) {
            throw new IllegalArgumentException("Name must set!");
        }
        this.name = name;
        this.namespace = namespace;
        this.value = null;
        this.children = children != null ? Collections.unmodifiableList(new ArrayList<CmisExtensionElement>(children)) : null;
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : null;
    }

    public CmisExtensionElementImpl(CmisExtensionElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Element must set!");
        }
        if (element.getName() == null) {
            throw new IllegalArgumentException("Name must set!");
        }
        this.name = element.getName();
        this.namespace = element.getNamespace();
        this.value = element.getValue();
        this.children = element.getChildren();
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public List<CmisExtensionElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes;
    }

    public String toTreeString(int level) {
        StringBuilder sb = new StringBuilder(512);
        this.nextTreelevel(sb, level);
        return sb.toString();
    }

    private void nextTreelevel(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(this.namespace == null ? "" : "{" + this.namespace + "}").append(this.name).append(" ").append(this.attributes == null ? "[]" : this.attributes).append(": ");
        if (this.children == null || this.children.isEmpty()) {
            sb.append(this.value);
            sb.append('\n');
        } else {
            sb.append('\n');
            for (CmisExtensionElement element : this.children) {
                if (element instanceof CmisExtensionElementImpl) {
                    sb.append(((CmisExtensionElementImpl)element).toTreeString(level + 1));
                    continue;
                }
                if (element == null) continue;
                for (int i = 0; i < level + 1; ++i) {
                    sb.append("  ");
                }
                sb.append(element.toString());
                sb.append('\n');
            }
        }
    }

    public String toString() {
        return (this.namespace == null ? "" : "{" + this.namespace + "}") + this.name + " " + (this.attributes == null ? "[]" : this.attributes) + ": " + (this.children == null || this.children.isEmpty() ? this.value : this.children.toString());
    }
}

