/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.FilingImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.RenditionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentImpl
extends FilingImpl
implements Document {
    private ContentStream fContent;
    private static final Logger LOG = LoggerFactory.getLogger((String)DocumentImpl.class.getName());

    @Override
    public ContentStream getContent() {
        return this.fContent;
    }

    @Override
    public void setContent(ContentStream content) {
        this.fContent = content;
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:isImmutable", requestedIds)) {
            properties.put("cmis:isImmutable", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isImmutable", Boolean.valueOf(false)));
        }
        if (FilterParser.isContainedInFilter("cmis:contentStreamFileName", requestedIds)) {
            properties.put("cmis:contentStreamFileName", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamFileName", null != this.fContent ? this.fContent.getFileName() : (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:contentStreamId", requestedIds)) {
            properties.put("cmis:contentStreamId", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamId", (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:contentStreamLength", requestedIds)) {
            properties.put("cmis:contentStreamLength", (PropertyData<?>)objFactory.createPropertyIntegerData("cmis:contentStreamLength", null != this.fContent ? this.fContent.getBigLength() : null));
        }
        if (FilterParser.isContainedInFilter("cmis:contentStreamMimeType", requestedIds)) {
            properties.put("cmis:contentStreamMimeType", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamMimeType", null != this.fContent ? this.fContent.getMimeType() : (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesId", requestedIds)) {
            properties.put("cmis:versionSeriesId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesId", this.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:isVersionSeriesCheckedOut", requestedIds)) {
            properties.put("cmis:isVersionSeriesCheckedOut", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isVersionSeriesCheckedOut", Boolean.valueOf(false)));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutBy", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionSeriesCheckedOutBy", (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutId", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesCheckedOutId", (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:isLatestVersion", requestedIds)) {
            properties.put("cmis:isLatestVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isLatestVersion", Boolean.valueOf(true)));
        }
        if (FilterParser.isContainedInFilter("cmis:isMajorVersion", requestedIds)) {
            properties.put("cmis:isMajorVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isMajorVersion", Boolean.valueOf(true)));
        }
        if (FilterParser.isContainedInFilter("cmis:isLatestMajorVersion", requestedIds)) {
            properties.put("cmis:isLatestMajorVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isLatestMajorVersion", Boolean.valueOf(true)));
        }
        if (FilterParser.isContainedInFilter("cmis:checkinComment", requestedIds)) {
            properties.put("cmis:checkinComment", (PropertyData<?>)objFactory.createPropertyStringData("cmis:checkinComment", (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:versionLabel", requestedIds)) {
            properties.put("cmis:versionLabel", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionLabel", (String)null));
        }
        if (FilterParser.isContainedInFilter("cmis:isPrivateWorkingCopy", requestedIds)) {
            properties.put("cmis:isPrivateWorkingCopy", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isPrivateWorkingCopy", Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean hasContent() {
        return null != this.fContent;
    }

    @Override
    public boolean hasRendition(String user) {
        return RenditionUtil.hasRendition(this, user);
    }
}

