/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationSettings {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfigurationSettings.class.getName());
    private static ConfigurationSettings singleInstance;
    private final Map<String, String> parameters;

    private ConfigurationSettings(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    private String getConfigurationValueIntern(String key) {
        return this.parameters.get(key);
    }

    public static String getConfigurationValueAsString(String key) {
        if (null == singleInstance) {
            LOG.error("ConfigurationSettings are not initialized. Initialize before reading values");
            throw new CmisRuntimeException("ConfigurationSettings are not initialized.");
        }
        return singleInstance.getConfigurationValueIntern(key);
    }

    public static Long getConfigurationValueAsLong(String key) {
        String str = ConfigurationSettings.getConfigurationValueAsString(key);
        if (null != str) {
            return Long.valueOf(str);
        }
        return null;
    }

    public static void init(Map<String, String> parameters) {
        singleInstance = new ConfigurationSettings(parameters);
    }

    public static Map<String, String> getParameters() {
        return ConfigurationSettings.singleInstance.parameters;
    }
}

