/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.xmlgraphics.util.Service;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.Locator;

public class ElementMappingRegistry {
    protected Log log = LogFactory.getLog((Class)ElementMappingRegistry.class);
    protected Map fobjTable = new HashMap();
    protected Map namespaces = new HashMap();

    public ElementMappingRegistry(FopFactory factory) {
        this.setupDefaultMappings();
    }

    private void setupDefaultMappings() {
        Iterator providers = Service.providers((Class)ElementMapping.class, (boolean)false);
        if (providers != null) {
            while (providers.hasNext()) {
                String mapping = (String)providers.next();
                try {
                    this.addElementMapping(mapping);
                }
                catch (IllegalArgumentException e) {
                    this.log.warn((Object)"Error while adding element mapping", (Throwable)e);
                }
            }
        }
    }

    public void addElementMapping(String mappingClassName) throws IllegalArgumentException {
        try {
            ElementMapping mapping = (ElementMapping)Class.forName(mappingClassName).newInstance();
            this.addElementMapping(mapping);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + mappingClassName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + mappingClassName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + mappingClassName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(mappingClassName + " is not an ElementMapping");
        }
    }

    public void addElementMapping(ElementMapping mapping) {
        this.fobjTable.put(mapping.getNamespaceURI(), mapping.getTable());
        this.namespaces.put(mapping.getNamespaceURI().intern(), mapping);
    }

    public ElementMapping.Maker findFOMaker(String namespaceURI, String localName, Locator locator) throws FOPException {
        Map table = (Map)this.fobjTable.get(namespaceURI);
        ElementMapping.Maker fobjMaker = null;
        if (table != null && (fobjMaker = (ElementMapping.Maker)table.get(localName)) == null) {
            fobjMaker = (ElementMapping.Maker)table.get("<default>");
        }
        if (fobjMaker == null) {
            if (this.namespaces.containsKey(namespaceURI.intern())) {
                throw new FOPException(FONode.errorText(locator) + "No element mapping definition found for " + FONode.getNodeString(namespaceURI, localName), locator);
            }
            fobjMaker = new UnknownXMLObj.Maker(namespaceURI);
        }
        return fobjMaker;
    }

    public DOMImplementation getDOMImplementationForNamespace(String namespaceURI) {
        ElementMapping mapping = (ElementMapping)this.namespaces.get(namespaceURI);
        if (mapping == null) {
            return null;
        }
        return mapping.getDOMImplementation();
    }

    public ElementMapping getElementMapping(String namespaceURI) {
        return (ElementMapping)this.namespaces.get(namespaceURI);
    }

    public boolean isKnownNamespace(String namespaceURI) {
        return this.namespaces.containsKey(namespaceURI);
    }
}

