/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.IntIterator4sorted;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;

public class FSIntArrayIndex<T extends FeatureStructure>
extends FSLeafIndexImpl<T> {
    private final IntVector indexIntVector;
    private final int initialSize;
    private final boolean isAnnotationIndex;
    private IntComparator annotationIntComparator = null;

    FSIntArrayIndex(CASImpl cas, Type type, int initialSize, int indexType, boolean isAnnotationIndex) {
        super(cas, type, indexType);
        this.initialSize = initialSize;
        this.indexIntVector = new IntVector(initialSize);
        this.isAnnotationIndex = isAnnotationIndex;
    }

    @Override
    boolean init(FSIndexComparator comp) {
        boolean rc = super.init(comp);
        return rc;
    }

    IntVector getVector() {
        return this.indexIntVector;
    }

    @Override
    public void flush() {
        if (this.indexIntVector.size() > this.initialSize) {
            this.indexIntVector.resetSize(this.initialSize);
        } else {
            this.indexIntVector.removeAllElements();
        }
    }

    @Override
    public final boolean insert(int fs) {
        int[] indexArray = this.indexIntVector.getArray();
        int length = this.indexIntVector.size();
        if (length == 0) {
            this.indexIntVector.add(fs);
            return true;
        }
        int last = indexArray[length - 1];
        if (this.compare(last, fs) < 0) {
            this.indexIntVector.add(fs);
            return true;
        }
        int pos = this.find(fs);
        if (pos >= 0 && !FSIndexRepositoryImpl.IS_ALLOW_DUP_ADD_2_INDEXES) {
            int pos2 = this.refineToExactFsSearch(fs, pos);
            if (pos2 < 0) {
                this.indexIntVector.add(pos + 1, fs);
            }
        } else if (pos >= 0) {
            this.indexIntVector.add(pos + 1, fs);
        } else {
            this.indexIntVector.add(-(pos + 1), fs);
        }
        return true;
    }

    @Override
    final boolean insert(int fs, int count) {
        int[] indexArray = this.indexIntVector.getArray();
        int length = this.indexIntVector.size();
        if (length == 0) {
            this.indexIntVector.multiAdd(fs, count);
            return true;
        }
        int last = indexArray[length - 1];
        if (this.compare(last, fs) < 0) {
            this.indexIntVector.multiAdd(fs, count);
            return true;
        }
        int pos = this.find(fs);
        if (pos >= 0 && !FSIndexRepositoryImpl.IS_ALLOW_DUP_ADD_2_INDEXES) {
            int pos2 = this.refineToExactFsSearch(fs, pos);
            if (pos2 < 0) {
                this.indexIntVector.multiAdd(pos + 1, fs, count);
            }
        } else if (pos >= 0) {
            this.indexIntVector.multiAdd(pos + 1, fs, count);
        } else {
            this.indexIntVector.multiAdd(-(pos + 1), fs, count);
        }
        return true;
    }

    private final int find(int fsRef) {
        return this.binarySearch(this.indexIntVector.getArray(), fsRef, 0, this.indexIntVector.size());
    }

    final int findLeftmost(int fsRef) {
        int pos;
        block2: {
            pos = this.find(fsRef);
            if (pos < 0 || pos >= this.size()) {
                return pos;
            }
            while (--pos >= 0) {
                int prev = this.indexIntVector.get(pos);
                if (this.compare(prev, fsRef) == 0) continue;
                ++pos;
                break block2;
            }
            pos = 0;
        }
        return pos;
    }

    final int findEq(int fsRef) {
        int pos = this.find(fsRef);
        if (pos < 0) {
            return pos;
        }
        int pos2 = this.refineToExactFsSearch(fsRef, pos);
        return pos2 == -1 ? -pos - 1 : pos2;
    }

    private final int binarySearch(int[] array, int ele, int start, int end) {
        --end;
        while (start <= end) {
            int i = (int)(((long)start + (long)end) / 2L);
            int comp = this.compare(ele, array[i]);
            if (comp == 0) {
                return i;
            }
            if (start == end) {
                if (comp < 0) {
                    return -i - 1;
                }
                return -i - 2;
            }
            if (comp < 0) {
                end = i - 1;
                continue;
            }
            start = i + 1;
        }
        return -start - 1;
    }

    private final int refineToExactFsSearch(int fsRef, int startingPos) {
        int[] array = this.indexIntVector.getArray();
        for (int movingPos = startingPos; movingPos >= 0; --movingPos) {
            int v = array[movingPos];
            if (v == fsRef) {
                return movingPos;
            }
            if (this.compare(v, fsRef) != 0) break;
        }
        int lenArray = this.indexIntVector.size();
        for (int movingPos = startingPos + 1; movingPos < lenArray; ++movingPos) {
            int v = array[movingPos];
            if (v == fsRef) {
                return movingPos;
            }
            if (this.compare(v, fsRef) != 0) break;
        }
        return -1;
    }

    @Override
    public ComparableIntPointerIterator<T> pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        return new IntIterator4sorted(this, detectIllegalIndexUpdates, comp);
    }

    @Override
    protected IntPointerIterator refIterator() {
        return new IntIterator4sorted(this, null);
    }

    @Override
    public LowLevelIterator ll_iterator() {
        return new IntIterator4sorted(this, null);
    }

    @Override
    protected IntPointerIterator refIterator(int fsAddr) {
        IntIterator4sorted it = new IntIterator4sorted(this, null);
        it.moveTo(fsAddr);
        return it;
    }

    public boolean contains(FeatureStructure fs) {
        return this.find(((FeatureStructureImpl)fs).getAddress()) >= 0;
    }

    public boolean ll_containsEq(int fsAddr) {
        return this.findEq(fsAddr) >= 0;
    }

    public FeatureStructure find(FeatureStructure fs) {
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        int fsRef = fsi.getAddress();
        int resultAddr = this.find(fsRef);
        if (resultAddr >= 0) {
            int foundFsRef = this.indexIntVector.get(resultAddr);
            return fsRef == foundFsRef ? fs : fsi.getCASImpl().createFS(foundFsRef);
        }
        return null;
    }

    @Override
    public int size() {
        return this.indexIntVector.size();
    }

    @Override
    public void deleteFS(FeatureStructure fs) {
        int addr = ((FeatureStructureImpl)fs).getAddress();
        this.remove(addr);
    }

    @Override
    public boolean remove(int fsRef) {
        int pos = this.findEq(fsRef);
        if (pos < 0) {
            return false;
        }
        this.indexIntVector.remove(pos);
        return true;
    }

    @Override
    protected void bulkAddTo(IntVector v) {
        v.addBulk(this.indexIntVector);
    }

    @Override
    public int compare(int fs1, int fs2) {
        if (this.isAnnotationIndex) {
            if (this.annotationIntComparator == null) {
                this.annotationIntComparator = this.lowLevelCAS.indexRepository.getAnnotationIntComparator();
            }
            return this.annotationIntComparator.compare(fs1, fs2);
        }
        return super.compare(fs1, fs2);
    }
}

