/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSImplComparator;
import org.apache.uima.cas.impl.FeatureImpl;

public class DefaultAnnotationComparator
implements FSImplComparator {
    private final int startCode;
    private final int endCode;
    private final CASImpl cas;

    public DefaultAnnotationComparator(CASImpl cas) {
        this.cas = cas;
        this.startCode = ((FeatureImpl)cas.getTypeSystem().getFeatureByFullName("begin")).getCode();
        this.endCode = ((FeatureImpl)cas.getTypeSystem().getFeatureByFullName("end")).getCode();
    }

    @Override
    public int compare(int addr1, int addr2) {
        int i2;
        if (addr1 == addr2) {
            return 0;
        }
        int i1 = this.cas.getFeatureValue(addr1, this.startCode);
        if (i1 < (i2 = this.cas.getFeatureValue(addr2, this.startCode))) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        i1 = this.cas.getFeatureValue(addr1, this.endCode);
        if (i1 > (i2 = this.cas.getFeatureValue(addr2, this.endCode))) {
            return -1;
        }
        if (i2 > i1) {
            return 1;
        }
        i1 = this.cas.getHeapValue(addr1);
        if (i1 < (i2 = this.cas.getHeapValue(addr2))) {
            return -1;
        }
        if (i2 < i1) {
            return 1;
        }
        return 0;
    }
}

