/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

public final class CountLimited
extends AbstractBaseCache {
    public static final String TYPE = "count-limited";
    public static final String PARAM_CAPACITY = "capacity";
    public static final int DEFAULT_CAPACITY = 30;
    private static final int LRU_OLD = 0;
    private static final int LRU_NEW = 1;
    private Hashtable _mapKeyPos = null;
    private Object[] _keys = null;
    private Object[] _values = null;
    private int[] _status = null;
    private int _capacity = 30;
    private int _cur = 0;

    public void initialize(Properties params) throws CacheAcquireException {
        super.initialize(params);
        String param = params.getProperty(PARAM_CAPACITY);
        try {
            if (param != null) {
                this._capacity = Integer.parseInt(param);
            }
            if (this._capacity <= 0) {
                this._capacity = 30;
            }
        }
        catch (NumberFormatException ex) {
            this._capacity = 30;
        }
        this._mapKeyPos = new Hashtable(this._capacity);
        this._keys = new Object[this._capacity];
        this._values = new Object[this._capacity];
        this._status = new int[this._capacity];
    }

    public String getType() {
        return TYPE;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public synchronized int size() {
        return this._mapKeyPos.size();
    }

    public synchronized boolean isEmpty() {
        return this._mapKeyPos.isEmpty();
    }

    public synchronized boolean containsKey(Object key) {
        return this._mapKeyPos.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        Iterator iter = this._mapKeyPos.values().iterator();
        while (iter.hasNext()) {
            Integer pos = (Integer)iter.next();
            if (pos == null || !(value == null ? this._values[pos] == null : value.equals(this._values[pos]))) continue;
            return true;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Integer pos = (Integer)this._mapKeyPos.get(key);
        if (pos == null) {
            return null;
        }
        int intPos = pos;
        this._status[intPos] = 1;
        return this._values[intPos];
    }

    public synchronized Object put(Object key, Object value) {
        Integer pos = (Integer)this._mapKeyPos.get(key);
        if (pos != null) {
            int intPos = pos;
            Object old = this._values[intPos];
            this._values[intPos] = value;
            this._status[intPos] = 1;
            return old;
        }
        while (this._status[this._cur] == 1) {
            this._status[this._cur] = 0;
            ++this._cur;
            if (this._cur < this._capacity) continue;
            this._cur = 0;
        }
        pos = this._keys[this._cur] != null ? (Integer)this._mapKeyPos.remove(this._keys[this._cur]) : new Integer(this._cur);
        this._keys[this._cur] = key;
        this._values[this._cur] = value;
        this._status[this._cur] = 1;
        this._mapKeyPos.put(key, pos);
        ++this._cur;
        if (this._cur >= this._capacity) {
            this._cur = 0;
        }
        return null;
    }

    public synchronized Object remove(Object key) {
        Integer pos = (Integer)this._mapKeyPos.remove(key);
        if (pos == null) {
            return null;
        }
        int intPos = pos;
        Object old = this._values[intPos];
        this._keys[intPos] = null;
        this._values[intPos] = null;
        this._status[intPos] = 0;
        return old;
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        this._mapKeyPos.clear();
        for (int intPos = 0; intPos < this._capacity; ++intPos) {
            this._keys[intPos] = null;
            this._values[intPos] = null;
            this._status[intPos] = 0;
        }
    }

    public synchronized Set keySet() {
        return Collections.unmodifiableSet(this._mapKeyPos.keySet());
    }

    public synchronized Collection values() {
        ArrayList<Object> col = new ArrayList<Object>(this._mapKeyPos.size());
        Iterator iter = this._mapKeyPos.values().iterator();
        while (iter.hasNext()) {
            Integer pos = (Integer)iter.next();
            if (pos == null) continue;
            col.add(this._values[pos]);
        }
        return Collections.unmodifiableCollection(col);
    }

    public synchronized Set entrySet() {
        Hashtable map = new Hashtable(this._mapKeyPos.size());
        Iterator iter = this._mapKeyPos.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer pos = (Integer)entry.getValue();
            if (pos == null) continue;
            map.put(entry.getKey(), this._values[pos]);
        }
        return Collections.unmodifiableSet(map.entrySet());
    }
}

