/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.GroupSet;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.OpTypes;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    public int resultRangePosition;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    public boolean isGroupingSets;
    boolean isDistinctGroups;
    public boolean isOrderSensitive;
    public boolean isSimpleDistinct;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    int startInnerRange = -1;
    int endInnerRange = -1;
    Expression queryCondition;
    Expression checkQueryCondition;
    Expression rowExpression;
    Expression[] exprColumns;
    HsqlArrayList exprColumnList;
    GroupSet groupSet;
    private int groupByColumnCount;
    private int havingColumnCount;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean hasRowID;
    private boolean isSimpleCount;
    private boolean isSingleMemoryTable;
    public boolean isUniqueResultRows;
    Type[] resultColumnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    public Index groupIndex;
    private RangeGroup[] outerRanges;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext, boolean bl) {
        this(compileContext);
        this.isValueList = bl;
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        rangeVariable.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(session, rangeVariable);
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
        this.isTable = true;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.resultRangePosition = compileContext.getNextResultRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
    }

    void addRangeVariable(Session session, RangeVariable rangeVariable) {
        this.rangeVariableList.add(rangeVariable);
    }

    public TableDerived getValueListTable() {
        if (this.isValueList) {
            RangeVariable rangeVariable = null;
            if (this.rangeVariables == null) {
                if (this.rangeVariableList.size() == 1) {
                    rangeVariable = (RangeVariable)this.rangeVariableList.get(0);
                }
            } else if (this.rangeVariables.length == 1) {
                rangeVariable = this.rangeVariables[0];
            }
            if (rangeVariable != null) {
                return (TableDerived)rangeVariable.getTable();
            }
        }
        return null;
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    public int getCurrentRangeVariableCount() {
        return this.rangeVariableList.size();
    }

    private void resolveRangeVariables(Session session, RangeGroup[] rangeGroupArray) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeGroup rangeGroup;
            if (this.rangeVariables[i].isLateral) {
                RangeVariable[] rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(this.rangeVariables, i);
                rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, this);
            } else {
                rangeGroup = rangeGroupArray == RangeGroup.emptyArray ? RangeGroup.emptyGroup : new RangeGroup.RangeGroupSimple(RangeVariable.emptyArray, this);
            }
            this.rangeVariables[i].resolveRangeTable(session, rangeGroup, rangeGroupArray);
        }
    }

    void addSelectColumnExpression(Expression expression) {
        if (expression.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (expression.opType == 99 && ((ExpressionColumn)expression).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression expression2 = (Expression)this.exprColumnList.get(0);
            if (expression2.opType == 99 && ((ExpressionColumn)expression2).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(expression);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression expression) {
        this.queryCondition = expression;
    }

    void setDistinctSelect() {
        this.isDistinctSelect = true;
    }

    void setDistinctGroups() {
        this.isDistinctGroups = true;
    }

    void addGroupingSets(Expression[] expressionArray) {
        this.groupSet = new GroupSet(expressionArray, this.isDistinctGroups);
    }

    void resolveColumnReferencesInGroupingSets(Session session, RangeGroup[] rangeGroupArray) {
        Expression expression;
        if (this.groupSet == null) {
            return;
        }
        Expression[] expressionArray = this.groupSet.groupExpressions;
        for (int i = 0; i < expressionArray.length; ++i) {
            expression = expressionArray[i];
            this.tempSet.clear();
            expression.resolveColumnReferences(session, this, this.rangeVariables.length, rangeGroupArray, this.tempSet, false);
            if (this.tempSet.isEmpty()) continue;
            if (session.database.sqlEnforceRefs) {
                ExpressionColumn.checkColumnsResolved(this.tempSet);
                continue;
            }
            Expression[] expressionArray2 = new Expression[this.exprColumnList.size()];
            this.exprColumnList.toArray(expressionArray2);
            Expression expression2 = expression.replaceAliasInOrderBy(session, expressionArray2, this.indexLimitVisible);
            if (expression2 != expression) {
                expressionArray[i] = expression2;
            }
            this.tempSet.clear();
            expression2.resolveColumnReferences(session, this, this.rangeVariables.length, RangeGroup.emptyArray, this.tempSet, false);
            ExpressionColumn.checkColumnsResolved(this.tempSet);
        }
        this.tempSet.clear();
        this.addGroupingExpressions(expressionArray, this.tempSet);
        Iterator iterator = this.tempSet.iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            if (expression.getType() == 25) {
                throw Error.error(5564);
            }
            expression.resultTableColumnIndex = this.indexLimitVisible + this.groupByColumnCount;
            this.exprColumnList.add(expression.resultTableColumnIndex, expression);
            ++this.groupByColumnCount;
        }
        this.groupSet.process();
    }

    void addGroupingExpressions(Expression[] expressionArray, OrderedHashSet orderedHashSet) {
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (expression.groupingType != 0) {
                this.isGroupingSets = true;
            }
            if (expression.opType == 25 || expression.opType == 26) {
                for (int j = 0; j < expression.nodes.length; ++j) {
                    this.addGroupingExpressions(expression.nodes, orderedHashSet);
                }
                continue;
            }
            if (expression.opType == 0) continue;
            expressionArray[i] = orderedHashSet.getOrAdd(expression);
            this.isGrouped = true;
        }
    }

    void addHavingExpression(Expression expression) {
        this.exprColumnList.add(expression);
        this.havingColumnCount = 1;
    }

    @Override
    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session, RangeGroup[] rangeGroupArray) {
        if (this.isReferencesResolved) {
            return;
        }
        this.outerRanges = rangeGroupArray;
        this.resolveRangeVariables(session, rangeGroupArray);
        this.resolveColumnReferencesForAsterisk();
        this.resolveColumnReferencesInGroupingSets(session, rangeGroupArray);
        this.setColumnIndexes();
        this.finaliseColumns();
        this.resolveColumnReferences(session, rangeGroupArray);
        this.setReferenceableColumns();
        this.unresolvedExpressions = Expression.resolveColumnSet(session, RangeVariable.emptyArray, rangeGroupArray, this.unresolvedExpressions);
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.isReferencesResolved = true;
    }

    @Override
    public boolean hasReference(RangeVariable rangeVariable) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areColumnsResolved() {
        return super.areColumnsResolved();
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
    }

    @Override
    void resolveTypesPartOne(Session session) {
        if (this.isPartOneResolved) {
            return;
        }
        this.resolveExpressionTypes(session);
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
        this.isPartOneResolved = true;
    }

    @Override
    void resolveTypesPartTwoRecursive(Session session) {
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            Type type = this.unionColumnTypes[i];
            this.exprColumns[i].setDataType(session, type);
        }
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int n;
        if (this.isPartTwoResolved) {
            return;
        }
        this.resolveGroups();
        this.resolveGroupingSets();
        for (n = 0; n < this.unionColumnTypes.length; ++n) {
            Type type = this.unionColumnTypes[n];
            if (type == null) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5567);
                }
                this.unionColumnTypes[n] = type = Type.SQL_VARCHAR_DEFAULT;
            }
            this.exprColumns[n].setDataType(session, type);
            if (!this.exprColumns[n].dataType.isArrayType() || this.exprColumns[n].dataType.collectionBaseType() != null) continue;
            throw Error.error(5567);
        }
        for (n = this.indexLimitVisible; n < this.indexStartHaving; ++n) {
            if (this.exprColumns[n].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability(session);
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
        this.mergeQuery(session);
        this.isPartTwoResolved = true;
    }

    @Override
    void resolveTypesPartThree(Session session) {
        if (this.isResolved) {
            return;
        }
        this.sortAndSlice.setSortIndex(this);
        this.setRangeVariableConditions(session);
        this.setDistinctConditions(session);
        this.setAggregateConditions(session);
        this.sortAndSlice.setSortRange(this);
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].resolveRangeTableTypes(session, this.rangeVariables);
        }
        this.setResultNullability();
        this.rangeVariableList = null;
        this.tempSet = null;
        this.compileContext = null;
        this.outerRanges = null;
        this.isResolved = true;
    }

    @Override
    public void addExtraConditions(Expression expression) {
        if (this.isAggregated || this.isGrouped) {
            return;
        }
        this.queryCondition = ExpressionLogical.andExpressions(this.queryCondition, expression);
    }

    private void resolveColumnReferences(Session session, RangeGroup[] rangeGroupArray) {
        Object object;
        int n;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            object = this.rangeVariables[n].getJoinCondition();
            if (object == null) continue;
            this.resolveColumnReferencesAndAllocate(session, (Expression)object, n + 1, rangeGroupArray, false);
        }
        this.resolveColumnReferencesAndAllocate(session, this.queryCondition, this.rangeVariables.length, rangeGroupArray, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[n], this.rangeVariables.length, rangeGroupArray, this.acceptsSequences);
            if (this.isGrouped || this.isDistinctSelect) continue;
            object = this.exprColumns[n].collectAllSubqueries(null);
            if (object != null) {
                this.isMergeable = false;
            }
            if ((object = this.exprColumns[n].collectAllExpressions(null, OpTypes.sequenceExpressionSet, OpTypes.subqueryAggregateExpressionSet)) == null) continue;
            this.isOrderSensitive = true;
            this.isMergeable = false;
            this.isBaseMergeable = false;
        }
        for (n = this.indexStartHaving; n < this.indexStartOrderBy; ++n) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[n], this.rangeVariables.length, rangeGroupArray, false);
        }
        this.resolveColumnReferencesInOrderBy(session, rangeGroupArray, this.sortAndSlice);
    }

    void resolveColumnReferencesInOrderBy(Session session, RangeGroup[] rangeGroupArray, SortAndSlice sortAndSlice) {
        int n = sortAndSlice.getOrderLength();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(expressionOrderBy);
            if (expressionOrderBy.getLeftNode().resultTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && expressionOrderBy.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            expressionOrderBy.replaceAliasInOrderBy(session, this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(session, expressionOrderBy, this.rangeVariables.length, RangeGroup.emptyArray, false);
            if (!this.isAggregated && !this.isGrouped || (bl = expressionOrderBy.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, OpTypes.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        if (sortAndSlice.limitCondition != null) {
            this.unresolvedExpressions = sortAndSlice.limitCondition.resolveColumnReferences(session, this, rangeGroupArray, this.unresolvedExpressions);
        }
        sortAndSlice.prepare(this.indexStartOrderBy);
    }

    private boolean resolveColumnReferences(Session session, Expression expression, int n, boolean bl) {
        if (expression == null) {
            return true;
        }
        int n2 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = expression.resolveColumnReferences(session, this, n, RangeGroup.emptyArray, this.unresolvedExpressions, bl);
        int n3 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return n2 == n3;
    }

    private void resolveColumnReferencesForAsterisk() {
        int n = 0;
        while (n < this.indexLimitVisible) {
            Expression expression = (Expression)this.exprColumnList.get(n);
            if (expression.getType() == 99) {
                int n2;
                this.exprColumnList.remove(n);
                String string = ((ExpressionColumn)expression).getTableName();
                if (string == null) {
                    this.addAllJoinedColumns(expression);
                } else {
                    n2 = 0;
                    for (int i = 0; i < this.rangeVariables.length; ++i) {
                        RangeVariable rangeVariable = this.rangeVariables[i].getRangeForTableName(string);
                        if (rangeVariable == null) continue;
                        HashSet hashSet = this.getAllNamedJoinColumns();
                        this.rangeVariables[i].addTableColumns(rangeVariable, expression, hashSet);
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        throw Error.error(5501, string);
                    }
                }
                for (n2 = 0; n2 < expression.nodes.length; ++n2) {
                    this.exprColumnList.add(n, expression.nodes[n2]);
                    ++n;
                }
                this.indexLimitVisible += expression.nodes.length - 1;
                continue;
            }
            ++n;
        }
    }

    private void resolveColumnReferencesAndAllocate(Session session, Expression expression, int n, RangeGroup[] rangeGroupArray, boolean bl) {
        if (expression == null) {
            return;
        }
        List list = expression.resolveColumnReferences(session, this, n, rangeGroupArray, null, bl);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Expression expression2 = (Expression)list.get(i);
                boolean bl2 = true;
                if (expression2.isSelfAggregate()) {
                    for (int j = 0; j < expression2.nodes.length; ++j) {
                        List list2 = expression2.nodes[j].resolveColumnReferences(session, this, n, RangeGroup.emptyArray, null, false);
                        for (int k = 0; k < rangeGroupArray.length; ++k) {
                            if (!rangeGroupArray[k].isVariable()) continue;
                            list2 = Expression.resolveColumnSet(session, rangeGroupArray[k].getRangeVariables(), RangeGroup.emptyArray, list2);
                        }
                        bl2 &= list2 == null;
                    }
                } else {
                    bl2 = this.resolveColumnReferences(session, expression2, n, bl);
                }
                if (bl2) {
                    if (expression2.isSelfAggregate()) {
                        this.addAggregateToSet(expression, expression2);
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(expression2);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(expression2);
            }
        }
    }

    private void addAggregateToSet(Expression expression, Expression expression2) {
        if (this.aggregateSet == null) {
            this.aggregateSet = new ArrayListIdentity();
        }
        this.aggregateSet.add(expression2);
        this.isAggregated = true;
        expression.setAggregate();
        expression2.setCorrelatedReferences(this);
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet hashSet = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable rangeVariable = (RangeVariable)this.rangeVariableList.get(i);
            if (rangeVariable.namedJoinColumns == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(rangeVariable.namedJoinColumns);
        }
        return hashSet;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        Expression expression = null;
        OrderedHashSet<String> orderedHashSet2 = new OrderedHashSet<String>();
        for (int i = this.rangeVariableList.size() - 1; i >= 0; --i) {
            RangeVariable rangeVariable2 = (RangeVariable)this.rangeVariableList.get(i);
            OrderedHashMap orderedHashMap = rangeVariable2.rangeTable.columnList;
            for (int j = 0; j < orderedHashMap.size(); ++j) {
                boolean bl2;
                ColumnSchema columnSchema = (ColumnSchema)orderedHashMap.get(j);
                String string = rangeVariable2.getColumnAlias((int)j).name;
                boolean bl3 = orderedHashSet.contains(string);
                boolean bl4 = rangeVariable2.namedJoinColumns != null && rangeVariable2.namedJoinColumns.contains(string);
                boolean bl5 = bl2 = !bl4 && !hashSet.add(string);
                if (bl2 && (!bl || bl3)) {
                    throw Error.error(5578, string);
                }
                if (!bl3) continue;
                orderedHashSet2.add(string);
                int n = rangeVariable2.rangeTable.getColumnIndex(columnSchema.getNameString());
                int n2 = rangeVariable.rangeTable.getColumnIndex(string);
                ExpressionLogical expressionLogical = new ExpressionLogical(rangeVariable2, n, rangeVariable, n2);
                ExpressionColumn expressionColumn = rangeVariable2.getColumnExpression(string);
                if (expressionColumn == null) {
                    expressionColumn = new ExpressionColumn(new Expression[]{expressionLogical.getLeftNode(), expressionLogical.getRightNode()}, string);
                    rangeVariable2.addNamedJoinColumnExpression(string, expressionColumn, n);
                    expression = ExpressionLogical.andExpressions(expression, expressionLogical);
                    rangeVariable.addNamedJoinColumnExpression(string, expressionColumn, n2);
                    continue;
                }
                if (rangeVariable.getColumnExpression(string) != null || rangeVariable2.isLeftJoin && !rangeVariable2.isRightJoin) continue;
                if (rangeVariable2.isLeftJoin && rangeVariable2.isRightJoin) {
                    expressionLogical = new ExpressionLogical(expressionColumn, expressionLogical.getRightNode());
                }
                expressionColumn.nodes = (Expression[])ArrayUtil.resizeArray(expressionColumn.nodes, expressionColumn.nodes.length + 1);
                expressionColumn.nodes[expressionColumn.nodes.length - 1] = expressionLogical.getRightNode();
                expression = ExpressionLogical.andExpressions(expression, expressionLogical);
                rangeVariable.addNamedJoinColumnExpression(string, expressionColumn, n2);
            }
            if (!rangeVariable2.isJoin) break;
        }
        if (bl && !orderedHashSet2.containsAll(orderedHashSet)) {
            throw Error.error(5501);
        }
        rangeVariable.addNamedJoinColumns(orderedHashSet2);
        return expression;
    }

    private void addAllJoinedColumns(Expression expression) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(hsqlArrayList);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression.nodes = expressionArray;
    }

    private void setColumnIndexes() {
        int n = 0;
        while (n < this.indexLimitVisible) {
            Expression expression = (Expression)this.exprColumnList.get(n);
            expression.resultTableColumnIndex = n++;
        }
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
    }

    private void finaliseColumns() {
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        this.exprColumnList = null;
        if (this.sortAndSlice.hasOrder()) {
            for (int i = 0; i < this.sortAndSlice.getOrderLength(); ++i) {
                this.exprColumns[this.indexStartOrderBy + i] = (Expression)this.sortAndSlice.exprList.get(i);
            }
        }
        this.rowExpression = new Expression(25, this.exprColumns);
    }

    private int replaceColumnIndexInOrderBy(Expression expression) {
        int n;
        Expression expression2 = expression.getLeftNode();
        if (expression2.getType() != 1) {
            return -1;
        }
        Type type = expression2.getDataType();
        if (type != null && type.typeCode == 4 && 0 < (n = ((Integer)expression2.getValue(null)).intValue()) && n <= this.indexLimitVisible) {
            expression.setLeftNode(this.exprColumns[n - 1]);
            return n;
        }
        throw Error.error(5576);
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            orderedHashSet = this.exprColumns[n].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            orderedHashSet = this.rangeVariables[n].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            orderedHashSet = this.exprColumns[i].collectRangeVariables(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectRangeVariables(orderedHashSet);
        }
        return orderedHashSet;
    }

    public void resolveExpressionTypes(Session session) {
        Expression expression;
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            expression = this.exprColumns[n];
            expression.resolveTypes(session, this.rowExpression);
            if (expression.getType() == 25) {
                throw Error.error(5565);
            }
            if (expression.getType() == 22 && expression.getDegree() > 1) {
                throw Error.error(5565);
            }
            if (expression.getDataType() == null || expression.getDataType().typeCode != 19) continue;
            throw Error.error(5565);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            expression = this.rangeVariables[n].getJoinCondition();
            if (expression == null) continue;
            expression.resolveTypes(session, null);
            if (expression.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session, null);
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingColumnCount != 0 && this.exprColumns[this.indexStartHaving].getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        if (this.sortAndSlice.limitCondition != null) {
            this.sortAndSlice.limitCondition.resolveTypes(session, null);
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int n = this.indexStartAggregates;
            int n2 = 0;
            while (n < this.indexLimitExpressions) {
                Expression expression = (Expression)this.tempSet.get(n2);
                this.exprColumns[n] = expression.duplicate();
                this.exprColumns[n].nodes = expression.nodes;
                this.exprColumns[n].dataType = expression.dataType;
                ++n;
                ++n2;
            }
            this.tempSet.clear();
        }
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeVariableResolver = new RangeVariableResolver(session, this);
        rangeVariableResolver.processConditions();
        this.rangeVariables = rangeVariableResolver.rangeVariables;
        if (this.rangeVariables.length > 1) {
            this.isMergeable = false;
        }
    }

    private void setDistinctConditions(Session session) {
        Index index;
        int n;
        int[] nArray;
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (!this.rangeVariables[i].isRightJoin) continue;
            return;
        }
        RangeVariable rangeVariable = null;
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (n = 0; n < this.groupByColumnCount; ++n) {
                if (this.exprColumns[this.indexLimitRowId + n].getType() != 2) {
                    return;
                }
                if (rangeVariable == null) {
                    rangeVariable = this.exprColumns[this.indexLimitRowId + n].getRangeVariable();
                } else if (rangeVariable != this.exprColumns[this.indexLimitRowId + n].getRangeVariable()) {
                    return;
                }
                nArray[n] = this.exprColumns[n].columnIndex;
            }
        } else {
            nArray = new int[this.indexLimitVisible];
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            if (this.exprColumns[n].getType() != 2) {
                return;
            }
            if (rangeVariable == null) {
                rangeVariable = this.exprColumns[n].getRangeVariable();
            } else if (rangeVariable != this.exprColumns[n].getRangeVariable()) {
                return;
            }
            if (this.isGrouped) continue;
            nArray[n] = this.exprColumns[n].columnIndex;
        }
        if (rangeVariable != this.rangeVariables[0]) {
            return;
        }
        n = ArrayUtil.areAllIntIndexesAsBooleanArray(nArray, rangeVariable.usedColumns) ? 1 : 0;
        if (n == 0) {
            return;
        }
        if (!rangeVariable.hasAnyIndexCondition() && (index = rangeVariable.rangeTable.getIndexForAllColumns(nArray)) != null) {
            rangeVariable.setSortIndex(index, false);
        }
        this.isSimpleDistinct = rangeVariable.setDistinctColumnsOnIndex(nArray);
    }

    private void setAggregateConditions(Session session) {
        if (!this.isAggregated) {
            return;
        }
        if (this.isGrouped) {
            this.setGroupedAggregateConditions(session);
        } else if (!this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression expression = this.exprColumns[this.indexStartAggregates];
            int n = expression.getType();
            Expression expression2 = expression.getLeftNode();
            switch (n) {
                case 76: 
                case 77: {
                    if (expression.hasCondition()) break;
                    SortAndSlice sortAndSlice = new SortAndSlice();
                    sortAndSlice.isGenerated = true;
                    sortAndSlice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!sortAndSlice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = sortAndSlice;
                    break;
                }
                case 74: {
                    if (expression.hasCondition() || this.rangeVariables.length != 1 || this.queryCondition != null) break;
                    if (expression2.getType() == 11) {
                        this.isSimpleCount = true;
                        break;
                    }
                    if (expression2.getNullability() != 0) break;
                    if (expression.isDistinctAggregate) {
                        Table table;
                        if (expression2.opType != 2 || (table = expression2.getRangeVariable().getTable()).getPrimaryKey().length != 1 || table.getColumn(table.getPrimaryKey()[0]) != expression2.getColumn()) break;
                        this.isSimpleCount = true;
                        break;
                    }
                    this.isSimpleCount = true;
                    break;
                }
            }
        }
    }

    private void setGroupedAggregateConditions(Session session) {
    }

    void checkLobUsage() {
    }

    private void resolveGroups() {
        int n;
        Expression expression;
        int n2;
        int n3;
        OrderedHashSet orderedHashSet = null;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (n3 = this.indexLimitVisible; n3 < this.indexLimitVisible + this.groupByColumnCount; ++n3) {
                this.exprColumns[n3].collectAllExpressions(this.tempSet, OpTypes.aggregateFunctionSet, OpTypes.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (n3 = 0; n3 < this.indexLimitVisible; ++n3) {
                if (this.exprColumns[n3].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, OpTypes.aggregateFunctionSet)) continue;
                this.tempSet.add(this.exprColumns[n3]);
            }
            if (!this.tempSet.isEmpty()) {
                if (!this.resolveForGroupBy(this.tempSet)) {
                    throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
                }
                orderedHashSet = new OrderedHashSet();
                orderedHashSet.addAll(this.tempSet);
            }
        } else if (this.isAggregated) {
            for (n3 = 0; n3 < this.indexLimitVisible; ++n3) {
                this.exprColumns[n3].collectAllExpressions(this.tempSet, OpTypes.columnExpressionSet, OpTypes.aggregateFunctionSet);
                for (n2 = 0; n2 < this.tempSet.size(); ++n2) {
                    expression = (Expression)this.tempSet.get(n2);
                    for (int i = 0; i < this.rangeVariables.length; ++i) {
                        if (this.rangeVariables[i] != expression.getRangeVariable()) continue;
                        throw Error.error(5574, expression.getSQL());
                    }
                }
                this.tempSet.clear();
            }
        }
        this.tempSet.clear();
        if (this.havingColumnCount != 0) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (n3 = this.indexLimitVisible; n3 < this.indexLimitVisible + this.groupByColumnCount; ++n3) {
                this.tempSet.add(this.exprColumns[n3]);
            }
            if (orderedHashSet != null) {
                this.tempSet.addAll(orderedHashSet);
            }
            if (!this.exprColumns[this.indexStartHaving].isComposedOf(this.tempSet, this.outerRanges, OpTypes.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            n3 = this.sortAndSlice.getOrderLength();
            for (n2 = 0; n2 < n3; ++n2) {
                expression = (Expression)this.sortAndSlice.exprList.get(n2);
                if (expression.resultTableColumnIndex != -1 || expression.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, OpTypes.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            n3 = this.sortAndSlice.getOrderLength();
            for (n2 = 0; n2 < n3; ++n2) {
                expression = (Expression)this.sortAndSlice.exprList.get(n2);
                if (expression.resultTableColumnIndex != -1 || expression.hasAggregate() || expression.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, OpTypes.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        OrderedHashSet<Expression> orderedHashSet2 = new OrderedHashSet<Expression>();
        n2 = this.indexStartAggregates;
        while (n2 < this.indexLimitExpressions) {
            expression = this.exprColumns[n2];
            expression.resultTableColumnIndex = n2++;
            orderedHashSet2.add(expression);
        }
        for (n2 = 0; n2 < this.indexStartHaving; ++n2) {
            if (this.exprColumns[n2].hasAggregate()) continue;
            expression = this.exprColumns[n2];
            expression.resultTableColumnIndex = n2;
            orderedHashSet2.add(expression);
        }
        if (!this.isAggregated) {
            return;
        }
        n2 = this.sortAndSlice.getOrderLength();
        for (n = 0; n < n2; ++n) {
            Expression expression2 = (Expression)this.sortAndSlice.exprList.get(n);
            if (!expression2.getLeftNode().hasAggregate()) continue;
            expression2.setAggregate();
        }
        for (n = this.indexStartOrderBy; n < this.indexStartAggregates; ++n) {
            if (!this.exprColumns[n].getLeftNode().hasAggregate()) continue;
            this.exprColumns[n].setAggregate();
        }
        for (n = 0; n < this.indexStartAggregates; ++n) {
            Expression expression3 = this.exprColumns[n];
            if (!expression3.hasAggregate()) continue;
            this.aggregateCheck[n] = true;
            this.exprColumns[n] = expression3.replaceExpressions(orderedHashSet2, this.resultRangePosition);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (n = 0; n < this.resolvedSubqueryExpressions.size(); ++n) {
                Expression expression4 = (Expression)this.resolvedSubqueryExpressions.get(n);
                expression4.replaceExpressions(orderedHashSet2, this.resultRangePosition);
            }
        }
    }

    public void resolveGroupingSets() {
        int n;
        if (!this.isGrouped) {
            return;
        }
        this.tempSet.clear();
        for (n = this.indexLimitVisible; n < this.indexStartHaving; ++n) {
            this.tempSet.add(this.exprColumns[n]);
        }
        for (n = this.indexStartAggregates; n < this.indexLimitExpressions; ++n) {
            this.tempSet.add(this.exprColumns[n]);
        }
        if (this.isGroupingSets) {
            for (n = 0; n < this.indexLimitVisible; ++n) {
                this.exprColumns[n] = this.exprColumns[n].replaceExpressions(this.tempSet, this.resultRangePosition);
            }
        }
        for (n = this.indexStartHaving; n < this.indexStartHaving + this.havingColumnCount; ++n) {
            this.exprColumns[n] = this.exprColumns[n].replaceExpressions(this.tempSet, this.resultRangePosition);
        }
    }

    boolean resolveForGroupBy(List list) {
        Object object;
        Object object2;
        int n;
        for (n = this.indexLimitVisible; n < this.indexLimitVisible + this.groupByColumnCount; ++n) {
            object2 = this.exprColumns[n];
            if (((Expression)object2).getType() != 2) continue;
            object = ((Expression)object2).getRangeVariable();
            int n2 = ((Expression)object2).getColumnIndex();
            ((RangeVariable)object).columnsInGroupBy[n2] = true;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            object2 = this.rangeVariables[n];
            ((RangeVariable)object2).hasKeyedColumnInGroupBy = ((RangeVariable)object2).rangeTable.getUniqueNotNullColumnGroup(((RangeVariable)object2).columnsInGroupBy) != null;
        }
        OrderedHashSet orderedHashSet = null;
        for (int i = 0; i < list.size(); ++i) {
            object = (Expression)list.get(i);
            orderedHashSet = ((Expression)object).getUnkeyedColumns(orderedHashSet);
        }
        return orderedHashSet == null;
    }

    @Override
    Result getResult(Session session, int n) {
        RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, this);
        int[] nArray = this.sortAndSlice.getLimits(session, this, n);
        int n2 = 0;
        int n3 = nArray[2];
        if (this.sortAndSlice.skipFullResult) {
            n2 = nArray[0];
            n3 = nArray[1];
        }
        Result result = this.buildResult(session, rowSetNavigatorData, n2, n3);
        rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
        if (this.isDistinctSelect) {
            rowSetNavigatorData.removeDuplicates();
        }
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            rowSetNavigatorData.sortOrder();
        }
        if (nArray != SortAndSlice.defaultLimits && !this.sortAndSlice.skipFullResult) {
            rowSetNavigatorData.trim(nArray[0], nArray[1]);
        }
        result.getNavigator().reset();
        return result;
    }

    private Result buildResult(Session session, RowSetNavigatorData rowSetNavigatorData, int n, int n2) {
        int n3;
        int n4;
        Result result = Result.newResult(rowSetNavigatorData);
        boolean bl = this.isGrouped && !this.isSimpleDistinct;
        result.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result.rsProperties = 8;
        }
        if (this.isSimpleCount) {
            this.getSimpleCountResult(session, rowSetNavigatorData);
            return result;
        }
        if (n2 == 0) {
            return result;
        }
        if (this.isGroupingSets) {
            session.sessionContext.setGroup(null);
        }
        int n5 = !this.isAggregated && !this.isSingleMemoryTable && !this.isGroupingSets ? session.resultMaxMemoryRows : 0;
        int n6 = 0;
        RangeIterator[] rangeIteratorArray = new RangeIterator[this.rangeVariables.length];
        for (n4 = 0; n4 < this.rangeVariables.length; ++n4) {
            rangeIteratorArray[n4] = this.rangeVariables[n4].getIterator(session);
        }
        session.sessionContext.rownum = 1;
        n4 = 0;
        while (true) {
            int n7;
            int n8;
            RangeIterator rangeIterator;
            if (n4 < n6) {
                boolean bl2 = true;
                for (n3 = n6 + 1; n3 < this.rangeVariables.length; ++n3) {
                    if (!this.rangeVariables[n3].isRightJoin) continue;
                    n6 = n3;
                    n4 = n3;
                    bl2 = false;
                    ((RangeVariable.RangeIteratorRight)rangeIteratorArray[n3]).setOnOuterRows();
                    break;
                }
                if (bl2) break;
            }
            if ((rangeIterator = rangeIteratorArray[n4]).next()) {
                if (n4 < this.rangeVariables.length - 1) {
                    ++n4;
                    continue;
                }
            } else {
                rangeIterator.reset();
                --n4;
                continue;
            }
            session.sessionData.startRowProcessing();
            Object[] objectArray = new Object[this.indexLimitData];
            int n9 = 0;
            if (this.isGroupingSets) {
                n9 = this.indexLimitVisible;
            }
            for (n8 = n9; n8 < this.indexStartAggregates; ++n8) {
                if (this.isAggregated && this.aggregateCheck[n8] || this.havingColumnCount > 0 && n8 == this.indexStartHaving) continue;
                objectArray[n8] = this.exprColumns[n8].getValue(session);
            }
            for (n8 = this.indexLimitVisible; n8 < this.indexLimitRowId; ++n8) {
                objectArray[n8] = n8 == this.indexLimitVisible ? Long.valueOf(rangeIterator.getRowId()) : rangeIterator.getCurrentRow();
            }
            ++session.sessionContext.rownum;
            if (n > 0) {
                --n;
                continue;
            }
            Object[] objectArray2 = null;
            if ((this.isAggregated || bl) && (objectArray2 = rowSetNavigatorData.getGroupData(objectArray)) != null) {
                objectArray = objectArray2;
            }
            for (n7 = this.indexStartAggregates; n7 < this.indexLimitExpressions; ++n7) {
                objectArray[n7] = this.exprColumns[n7].updateAggregatingValue(session, (SetFunction)objectArray[n7]);
            }
            if (objectArray2 == null) {
                rowSetNavigatorData.add(objectArray);
                if (this.isSimpleDistinct) {
                    for (n7 = 1; n7 < this.rangeVariables.length; ++n7) {
                        rangeIteratorArray[n7].reset();
                    }
                    n4 = 0;
                }
            } else if (this.isAggregated) {
                rowSetNavigatorData.update(objectArray2, objectArray);
            }
            if ((n7 = rowSetNavigatorData.getSize()) == n5) {
                rowSetNavigatorData = new RowSetNavigatorDataTable(session, this, rowSetNavigatorData);
                result.setNavigator(rowSetNavigatorData);
                n5 = 0;
            }
            if ((!this.isAggregated && !bl || this.sortAndSlice.isGenerated) && n7 >= n2) break;
        }
        rowSetNavigatorData.reset();
        for (n4 = 0; n4 < this.rangeVariables.length; ++n4) {
            rangeIteratorArray[n4].reset();
        }
        if (!this.isGroupingSets && !this.isAggregated && this.havingColumnCount == 0) {
            return result;
        }
        session.sessionContext.setRangeIterator(rowSetNavigatorData);
        if (this.isGroupingSets) {
            session.sessionContext.setGroupSet(this.groupSet);
            Iterator iterator = this.groupSet.getIterator();
            Object[][] objectArray = rowSetNavigatorData.getDataTable();
            n3 = rowSetNavigatorData.getSize();
            rowSetNavigatorData.clear();
            if (this.groupSet.nullSets != 0) {
                int n10;
                Object[] objectArray3 = new Object[this.indexLimitData];
                for (n10 = 0; n10 < this.indexStartAggregates; ++n10) {
                    objectArray3[n10] = this.exprColumns[n10].getValue(session);
                }
                rowSetNavigatorData.add(objectArray3);
                rowSetNavigatorData.next();
                if (this.isAggregated) {
                    for (n10 = 0; n10 < n3; ++n10) {
                        Object[] objectArray4 = objectArray[n10];
                        for (int i = this.indexStartAggregates; i < this.indexLimitExpressions; ++i) {
                            objectArray3[i] = this.exprColumns[i].updateAggregatingValue(session, (SetFunction)objectArray3[i], (SetFunction)objectArray4[i]);
                        }
                    }
                    for (n10 = this.indexStartAggregates; n10 < this.indexLimitExpressions; ++n10) {
                        objectArray3[n10] = this.exprColumns[n10].getAggregatedValue(session, (SetFunction)objectArray3[n10]);
                    }
                    for (n10 = 0; n10 < this.indexStartAggregates; ++n10) {
                        if (!this.aggregateCheck[n10]) continue;
                        objectArray3[n10] = this.exprColumns[n10].getValue(session);
                    }
                }
                for (n10 = 1; n10 < this.groupSet.nullSets; ++n10) {
                    rowSetNavigatorData.add(objectArray3);
                    rowSetNavigatorData.next();
                }
            }
            while (iterator.hasNext()) {
                rowSetNavigatorData.resetRowMap();
                List list = (List)iterator.next();
                session.sessionContext.setGroup(list);
                for (int i = 0; i < n3; ++i) {
                    int n11;
                    Object[] objectArray5 = objectArray[i];
                    Object[] objectArray6 = new Object[this.indexLimitData];
                    for (int j = this.indexLimitVisible; j < this.indexStartHaving; ++j) {
                        if (!list.contains(j)) continue;
                        objectArray6[j] = objectArray5[j];
                    }
                    Object[] objectArray7 = rowSetNavigatorData.getGroupDataAndPosition(objectArray6);
                    if (objectArray7 == null) {
                        rowSetNavigatorData.add(objectArray6);
                        rowSetNavigatorData.absolute(rowSetNavigatorData.getSize() - 1);
                    } else {
                        objectArray6 = objectArray7;
                    }
                    for (n11 = this.indexStartAggregates; n11 < this.indexLimitExpressions; ++n11) {
                        objectArray6[n11] = this.exprColumns[n11].updateAggregatingValue(session, (SetFunction)objectArray6[n11], (SetFunction)objectArray5[n11]);
                    }
                    for (n11 = 0; n11 < this.indexLimitVisible; ++n11) {
                        objectArray6[n11] = this.exprColumns[n11].getValue(session);
                    }
                    rowSetNavigatorData.update(objectArray7, objectArray6);
                }
            }
        }
        rowSetNavigatorData.reset();
        if (this.isAggregated) {
            if (!bl && rowSetNavigatorData.getSize() == 0) {
                Object[] objectArray = new Object[this.exprColumns.length];
                for (int i = 0; i < this.indexStartAggregates; ++i) {
                    if (this.aggregateCheck[i]) continue;
                    objectArray[i] = this.exprColumns[i].getValue(session);
                }
                rowSetNavigatorData.add(objectArray);
            }
            if (this.isGroupingSets) {
                for (int i = 0; i < this.groupSet.nullSets; ++i) {
                    rowSetNavigatorData.next();
                }
            }
            while (rowSetNavigatorData.next()) {
                int n12;
                Object[] objectArray = rowSetNavigatorData.getCurrent();
                for (n12 = this.indexStartAggregates; n12 < this.indexLimitExpressions; ++n12) {
                    objectArray[n12] = this.exprColumns[n12].getAggregatedValue(session, (SetFunction)objectArray[n12]);
                }
                for (n12 = 0; n12 < this.indexStartAggregates; ++n12) {
                    if (!this.aggregateCheck[n12]) continue;
                    objectArray[n12] = this.exprColumns[n12].getValue(session);
                }
            }
        }
        rowSetNavigatorData.reset();
        if (this.havingColumnCount != 0) {
            while (rowSetNavigatorData.next()) {
                Object[] objectArray = rowSetNavigatorData.getCurrent();
                boolean bl3 = this.exprColumns[this.indexStartHaving].testCondition(session);
                if (bl3) continue;
                rowSetNavigatorData.removeCurrent();
            }
            rowSetNavigatorData.reset();
        }
        session.sessionContext.unsetRangeIterator(rowSetNavigatorData);
        return result;
    }

    private void getSimpleCountResult(Session session, RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = new Object[this.indexLimitData];
        Table table = this.rangeVariables[0].getTable();
        table.materialise(session);
        PersistentStore persistentStore = table.getRowStore(session);
        long l = persistentStore.elementCount(session);
        objectArray[this.indexStartAggregates] = ValuePool.getLong(l);
        rowSetNavigatorData.add(objectArray);
        rowSetNavigatorData.reset();
        session.sessionContext.setRangeIterator(rowSetNavigatorData);
        if (rowSetNavigatorData.next()) {
            objectArray = rowSetNavigatorData.getCurrent();
            for (int i = 0; i < this.indexStartAggregates; ++i) {
                objectArray[i] = this.exprColumns[i].getValue(session);
            }
        }
        session.sessionContext.unsetRangeIterator(rowSetNavigatorData);
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            String string = expression.getAlias();
            if (string.isEmpty()) {
                HsqlNameManager.HsqlName hsqlName = HsqlNameManager.getAutoColumnName(i);
                expression.setAlias(hsqlName);
                continue;
            }
            int n = intValueHashMap.get((Object)string, -1);
            if (n == -1) {
                intValueHashMap.put(string, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[n] = false;
        }
    }

    void setColumnAliases(HsqlNameManager.SimpleName[] simpleNameArray) {
        if (simpleNameArray.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].setAlias(simpleNameArray[i]);
        }
    }

    private void createResultMetaData(Session session) {
        this.resultMetaData = ResultMetaData.newResultMetaData(this.resultColumnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            String string;
            Expression expression = this.exprColumns[i];
            ColumnSchema columnSchema = null;
            columnSchema = expression.getColumn();
            this.resultMetaData.columnTypes[i] = expression.getDataType();
            ColumnBase columnBase = columnSchema == null ? new ColumnBase() : new ColumnBase(session.database.getCatalogName(), columnSchema, this.lowerCaseResultIdentifier);
            columnBase.setType(expression.getDataType());
            HsqlNameManager.SimpleName simpleName = expression.getSimpleName();
            String string2 = string = simpleName == null ? "" : simpleName.name;
            if (this.lowerCaseResultIdentifier && !simpleName.isNameQuoted) {
                string = string.toLowerCase(Locale.ENGLISH);
            }
            this.resultMetaData.columns[i] = columnBase;
            this.resultMetaData.columnLabels[i] = string;
        }
    }

    private void setResultNullability() {
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            RangeVariable rangeVariable;
            Expression expression = this.exprColumns[i];
            byte by = expression.getNullability();
            if (expression.opType == 2 && (rangeVariable = expression.getRangeVariable()) != null && (rangeVariable.rangePositionInJoin < this.startInnerRange || rangeVariable.rangePositionInJoin >= this.endInnerRange)) {
                by = 1;
            }
            this.resultMetaData.columns[i].setNullability(by);
        }
    }

    @Override
    void createTable(Session session) {
        int[] nArray;
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                nArray[i] = this.indexLimitRowId + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            nArray = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        }
    }

    private void createFullIndex(Session session) {
        int[] nArray = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(nArray);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
    }

    private void setResultColumnTypes() {
        Expression expression;
        int n;
        this.resultColumnTypes = new Type[this.indexLimitData];
        for (n = 0; n < this.indexLimitVisible; ++n) {
            expression = this.exprColumns[n];
            this.resultColumnTypes[n] = expression.getDataType();
        }
        for (n = this.indexLimitVisible; n < this.indexLimitRowId; ++n) {
            this.resultColumnTypes[n] = n == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (n = this.indexLimitRowId; n < this.indexLimitData; ++n) {
            expression = this.exprColumns[n];
            Type type = expression.getDataType();
            if (type.getCollation() != expression.collation && expression.collation != null) {
                type = Type.getType(type, expression.collation);
            }
            this.resultColumnTypes[n] = type;
        }
    }

    @Override
    void createResultTable(Session session) {
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.getSubqueryTableName();
        int n = this.persistenceScope == 21 ? 2 : 9;
        OrderedHashMap<String, ColumnSchema> orderedHashMap = new OrderedHashMap<String, ColumnSchema>();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            HsqlNameManager.SimpleName simpleName = expression.getSimpleName();
            String string = simpleName.name;
            HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newColumnSchemaHsqlName(hsqlName, simpleName);
            if (!this.accessibleColumns[i]) {
                string = HsqlNameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema columnSchema = new ColumnSchema(hsqlName2, expression.dataType, true, false, null);
            orderedHashMap.add(string, columnSchema);
        }
        this.resultTable = new TableDerived(session.database, hsqlName, n, this.resultColumnTypes, orderedHashMap, ValuePool.emptyIntArray);
    }

    public String getSQL() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT").append(' ');
        int n2 = this.indexLimitVisible;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.exprColumns[n].getSQL());
        }
        stringBuilder.append("FROM");
        n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            RangeVariable rangeVariable = this.rangeVariables[n];
            if (n > 0) {
                if (rangeVariable.isLeftJoin && rangeVariable.isRightJoin) {
                    stringBuilder.append("FULL").append(' ');
                } else if (rangeVariable.isLeftJoin) {
                    stringBuilder.append("LEFT").append(' ');
                } else if (rangeVariable.isRightJoin) {
                    stringBuilder.append("RIGHT").append(' ');
                }
                stringBuilder.append("JOIN").append(' ');
            }
            stringBuilder.append(rangeVariable.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            stringBuilder.append(' ').append("GROUP").append(' ').append("BY");
            n2 = this.indexLimitVisible + this.groupByColumnCount;
            for (n = this.indexLimitVisible; n < n2; ++n) {
                stringBuilder.append(this.exprColumns[n].getSQL());
                if (n >= n2 - 1) continue;
                stringBuilder.append(',');
            }
        }
        if (this.havingColumnCount != 0) {
            stringBuilder.append(' ').append("HAVING").append(' ');
            stringBuilder.append(this.exprColumns[this.indexStartHaving].getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            n2 = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            stringBuilder.append(' ').append("ORDER").append("BY").append(' ');
            for (n = this.indexStartOrderBy; n < n2; ++n) {
                stringBuilder.append(this.exprColumns[n].getSQL());
                if (n >= n2 - 1) continue;
                stringBuilder.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            stringBuilder.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return stringBuilder.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public String describe(Session session, int n) {
        String string;
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (n3 = 0; n3 < n; ++n3) {
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append((CharSequence)stringBuilder).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("columns=[");
        for (n3 = 0; n3 < this.indexLimitVisible; ++n3) {
            n2 = n3;
            if (this.exprColumns[n3].getType() == 5) {
                n2 = this.exprColumns[n3].columnIndex;
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            string = this.exprColumns[n2].describe(session, 2);
            stringBuilder2.append(string, 0, string.length() - 1);
            if (this.resultMetaData.columns[n3].getNullability() == 0) {
                stringBuilder2.append(" not nullable\n");
                continue;
            }
            stringBuilder2.append(" nullable\n");
        }
        stringBuilder2.append("\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        for (n3 = 0; n3 < this.rangeVariables.length; ++n3) {
            stringBuilder2.append((CharSequence)stringBuilder).append("[");
            stringBuilder2.append("range variable ").append(n3 + 1).append("\n");
            stringBuilder2.append(this.rangeVariables[n3].describe(session, n + 2));
            stringBuilder2.append((CharSequence)stringBuilder).append("]");
        }
        stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        String string2 = string = this.queryCondition == null ? "null" : this.queryCondition.describe(session, n);
        if (this.isGrouped) {
            stringBuilder2.append((CharSequence)stringBuilder).append("groupColumns=[");
            for (n3 = this.indexLimitRowId; n3 < this.indexLimitRowId + this.groupByColumnCount; ++n3) {
                n2 = n3;
                if (this.exprColumns[n3].getType() == 5) {
                    n2 = this.exprColumns[n3].columnIndex;
                }
                stringBuilder2.append(this.exprColumns[n2].describe(session, n));
            }
            stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        }
        if (this.havingColumnCount != 0) {
            string = this.exprColumns[this.indexStartHaving].describe(session, n);
            stringBuilder2.append((CharSequence)stringBuilder).append("havingCondition=[").append(string).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            stringBuilder2.append((CharSequence)stringBuilder).append("order by=[\n");
            for (n3 = 0; n3 < this.sortAndSlice.exprList.size(); ++n3) {
                stringBuilder2.append((CharSequence)stringBuilder).append(((Expression)this.sortAndSlice.exprList.get(n3)).describe(session, n));
            }
            if (this.sortAndSlice.primaryTableIndex != null) {
                stringBuilder2.append((CharSequence)stringBuilder).append("uses index");
            }
            stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                stringBuilder2.append((CharSequence)stringBuilder).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, stringBuilder.length())).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                stringBuilder2.append((CharSequence)stringBuilder).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, stringBuilder.length())).append("]\n");
            }
        }
        return stringBuilder2.toString();
    }

    void setMergeability() {
        this.isOrderSensitive |= this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder();
        if (this.isOrderSensitive) {
            this.isMergeable = false;
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
        if (this.isGrouped || this.isDistinctSelect) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
        if (this.rangeVariables.length != 1) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
    }

    void setUpdatability(Session session) {
        String string;
        Object object;
        int n;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (this.isGrouped || this.isDistinctSelect || this.isAggregated) {
            return;
        }
        if (!this.isBaseMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if ((this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) && !session.database.sqlSyntaxDb2) {
            return;
        }
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Table table2 = table.getBaseTable();
        if (table2 == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        int[] nArray = table.getBaseTableColumnMap();
        int[] nArray2 = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getName()) || this.tempSet.contains(table2.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            object = this.exprColumns[n];
            if (((Expression)object).getType() == 2) {
                string = ((Expression)object).getColumn().getName().name;
                if (intValueHashMap.containsKey(string)) {
                    intValueHashMap.put(string, 1);
                    continue;
                }
                intValueHashMap.put(string, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, (Expression)object);
            if (!this.tempSet.contains(table.getName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (n = 0; n < this.indexLimitVisible; ++n) {
            if (this.accessibleColumns[n] && ((Expression)(object = this.exprColumns[n])).getType() == 2 && intValueHashMap.get(string = ((Expression)object).getColumn().getName().name) == 0) {
                int n2 = table.findColumn(string);
                nArray2[n] = nArray[n2];
                if (nArray2[n] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            nArray2[n] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] blArray = table2.getColumnCheckList(nArray2);
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n] || ((ColumnBase)(object = table2.getColumn(n))).isIdentity() || ((ColumnSchema)object).isGenerated() || ((ColumnSchema)object).hasDefault() || ((ColumnSchema)object).isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = nArray2;
            this.baseTable = table2;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            this.hasRowID = true;
            if (!table2.isFileBased()) {
                ++this.indexLimitRowId;
                this.isSingleMemoryTable = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery(Session session) {
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Expression expression = this.queryCondition;
        QueryExpression queryExpression = table.getQueryExpression();
        if (this.isBaseMergeable && queryExpression != null && queryExpression.isMergeable) {
            QuerySpecification querySpecification = queryExpression.getMainSelect();
            this.rangeVariables[0] = querySpecification.rangeVariables[0];
            this.rangeVariables[0].resetConditions();
            for (int i = 0; i < this.indexLimitExpressions; ++i) {
                Expression expression2 = this.exprColumns[i];
                this.exprColumns[i] = expression2.replaceColumnReferences(session, rangeVariable, querySpecification.exprColumns);
            }
            if (expression != null) {
                expression = expression.replaceColumnReferences(session, rangeVariable, querySpecification.exprColumns);
            }
            Expression expression3 = querySpecification.queryCondition;
            this.checkQueryCondition = querySpecification.checkQueryCondition;
            this.queryCondition = ExpressionLogical.andExpressions(expression3, expression);
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = expression;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet orderedHashSet, Expression expression) {
        expression.collectAllExpressions(orderedHashSet, OpTypes.subqueryExpressionSet, OpTypes.emptyExpressionSet);
        int n = orderedHashSet.size();
        for (int i = 0; i < n; ++i) {
            Expression expression2 = (Expression)orderedHashSet.get(i);
            expression2.collectObjectNames(orderedHashSet);
        }
    }

    @Override
    public OrderedHashSet getSubqueries() {
        int n;
        OrderedHashSet orderedHashSet = null;
        for (n = 0; n < this.indexLimitExpressions; ++n) {
            orderedHashSet = this.exprColumns[n].collectAllSubqueries(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllSubqueries(orderedHashSet);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            OrderedHashSet orderedHashSet2 = this.rangeVariables[n].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectOuterColumnExpressions(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, OpTypes.columnExpressionSet, OpTypes.subqueryAggregateExpressionSet)) == null) {
            return null;
        }
        for (int i = orderedHashSet.size() - 1; i >= 0; --i) {
            Expression expression = (Expression)orderedHashSet.get(i);
            if (ArrayUtil.find(this.rangeVariables, expression.getRangeVariable()) >= 0) {
                orderedHashSet.remove(i);
            }
            if (!orderedHashSet2.contains(expression)) continue;
            orderedHashSet.remove(i);
        }
        if (orderedHashSet.isEmpty()) {
            orderedHashSet = null;
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            orderedHashSet = this.exprColumns[n].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVariables[n].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public void collectObjectNames(Set set) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            HsqlNameManager.HsqlName hsqlName = this.rangeVariables[n].getTable().getName();
            set.add(hsqlName);
        }
    }

    @Override
    public void replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n] = this.exprColumns[n].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            this.rangeVariables[n].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            this.rangeVariables[n].getSubqueries();
        }
    }

    @Override
    public void replaceExpressions(OrderedHashSet orderedHashSet, int n) {
        int n2;
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            this.exprColumns[n2] = this.exprColumns[n2].replaceExpressions(orderedHashSet, n);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceExpressions(orderedHashSet, n);
        }
        int n3 = this.rangeVariables.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.rangeVariables[n2].replaceExpressions(orderedHashSet, n);
        }
    }

    @Override
    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            stringArray[i] = this.exprColumns[i].getAlias();
        }
        return stringArray;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.resultColumnTypes.length == this.indexLimitVisible) {
            return this.resultColumnTypes;
        }
        Type[] typeArray = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.resultColumnTypes, typeArray, typeArray.length);
        return typeArray;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    void getBaseTableNames(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table table = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName hsqlName = table.getName();
            if (table.isView() || table.isDataReadOnly() || table.isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
    }

    @Override
    boolean isEquivalent(QueryExpression queryExpression) {
        if (!(queryExpression instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification querySpecification = (QuerySpecification)queryExpression;
        if (!Expression.equals(this.exprColumns, querySpecification.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, querySpecification.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != querySpecification.rangeVariables.length) {
            return false;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].getTable() == querySpecification.rangeVariables[i].getTable()) continue;
            return false;
        }
        return true;
    }
}

