/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.outputconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.outputconnection.OutputConnection;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;

public class OutputConnectionManager
extends BaseTable
implements IOutputConnectionManager {
    public static final String _rcsid = "@(#)$Id: OutputConnectionManager.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "connectionname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected final ICacheManager cacheManager;
    protected final IThreadContext threadContext;
    protected final ILockManager lockManager;
    protected static final String outputsLock = "OUTPUTS_LOCK";
    protected static final int FETCH_MAX = 200;

    public OutputConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "outputconnections");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription classIndex = new IndexDescription(false, new String[]{classNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (classIndex != null && id.equals((Object)classIndex)) {
                    classIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (classIndex == null) break block3;
            this.performAddIndex(null, classIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        IOutputConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IOutputConnection conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 1) {
            throw new IOException("Unknown output connection configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IOutputConnection conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            this.save(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOutputConnection[] getAllConnections() throws ManifoldCFException {
        this.lockManager.enterReadLock(outputsLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(OutputConnectionManager.getOutputConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT connectionname,lower(connectionname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IOutputConnection[] iOutputConnectionArray = this.loadMultiple(names);
            return iOutputConnectionArray;
        }
        finally {
            this.lockManager.leaveReadLock(outputsLock);
        }
    }

    @Override
    public IOutputConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    @Override
    public IOutputConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        IOutputConnection[] rval = new IOutputConnection[names.length];
        if (names.length == 0) {
            return rval;
        }
        int inputIndex = 0;
        int outputIndex = 0;
        while (names.length - inputIndex > 200) {
            outputIndex = this.loadMultipleInternal(rval, outputIndex, names, inputIndex, 200);
            inputIndex += 200;
        }
        this.loadMultipleInternal(rval, outputIndex, names, inputIndex, names.length - inputIndex);
        return rval;
    }

    protected int loadMultipleInternal(IOutputConnection[] rval, int outputIndex, String[] fetchNames, int inputIndex, int length) throws ManifoldCFException {
        OutputConnection[] results;
        OutputConnectionDescription[] objectDescriptions = new OutputConnectionDescription[length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < length; ++i) {
            ssb.clear();
            String name = fetchNames[inputIndex + i];
            ssb.add(OutputConnectionManager.getOutputConnectionKey(name));
            objectDescriptions[i] = new OutputConnectionDescription(name, new StringSet(ssb));
        }
        OutputConnectionExecutor exec = new OutputConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        for (OutputConnection result : results = exec.getResults()) {
            rval[outputIndex++] = result;
        }
        return outputIndex;
    }

    @Override
    public IOutputConnection create() throws ManifoldCFException {
        OutputConnection rval = new OutputConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(IOutputConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(OutputConnectionManager.getOutputConnectionsKey());
        ssb.add(OutputConnectionManager.getOutputConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        this.lockManager.enterNonExWriteLock(outputsLock);
        try {
            ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
            try {
                this.beginTransaction();
                try {
                    if (AgentManagerFactory.isOutputConnectionInUse(this.threadContext, name)) {
                        throw new ManifoldCFException("Can't delete output connection '" + name + "': existing entities refer to it");
                    }
                    ManifoldCF.noteConfigurationChange();
                    ArrayList params = new ArrayList();
                    String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
                    this.performDelete("WHERE " + query, params, null);
                    this.cacheManager.invalidateKeys(ch);
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.cacheManager.leaveCache(ch);
            }
        }
        finally {
            this.lockManager.leaveNonExWriteLock(outputsLock);
        }
    }

    @Override
    public String[] findConnectionsForConnector(String className) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(OutputConnectionManager.getOutputConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(classNameField, (Object)className)});
        IResultSet set = this.performQuery("SELECT connectionname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        Object[] rval = new String[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(nameField);
        }
        Arrays.sort(rval);
        return rval;
    }

    @Override
    public boolean checkConnectorExists(String name) throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(OutputConnectionManager.getOutputConnectionKey(name));
            StringSet localCacheKeys = new StringSet(ssb);
            ArrayList params = new ArrayList();
            String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
            IResultSet set = this.performQuery("SELECT classname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("No such connection: '" + name + "'");
            }
            IResultRow row = set.getRow(0);
            String className = (String)row.getValue(classNameField);
            IOutputConnectorManager cm = OutputConnectorManagerFactory.make(this.threadContext);
            boolean bl = cm.isInstalled(className);
            return bl;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public String getConnectionNameColumn() {
        return nameField;
    }

    protected static String getOutputConnectionsKey() {
        return CacheKeyFactory.makeOutputConnectionsKey();
    }

    protected static String getOutputConnectionKey(String connectionName) {
        return CacheKeyFactory.makeOutputConnectionKey(connectionName);
    }

    protected OutputConnection[] getOutputConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        OutputConnection[] rval = new OutputConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.maxClauseGetOutputConnectionsChunk();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getOutputConnectionsChunk(rval, returnIndex, params);
                    params.clear();
                    j = 0;
                }
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getOutputConnectionsChunk(rval, returnIndex, params);
            }
            OutputConnection[] outputConnectionArray = rval;
            return outputConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected int maxClauseGetOutputConnectionsChunk() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void getOutputConnectionsChunk(OutputConnection[] rval, Map returnIndex, ArrayList params) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(nameField, (List)params)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            OutputConnection rc = new OutputConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
    }

    protected static class OutputConnectionExecutor
    extends ExecutorBase {
        protected OutputConnectionManager thisManager;
        protected OutputConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public OutputConnectionExecutor(OutputConnectionManager manager, OutputConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new OutputConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public OutputConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                OutputConnectionDescription desc = (OutputConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getOutputConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            OutputConnectionDescription objectDesc = (OutputConnectionDescription)objectDescription;
            OutputConnection ci = (OutputConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class OutputConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public OutputConnectionDescription(String connectionName, StringSet invKeys) {
            super("outputconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof OutputConnectionDescription)) {
                return false;
            }
            OutputConnectionDescription d = (OutputConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

