/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.internet.AddressException;

public class NewsAddress
extends Address {
    private static final long serialVersionUID = -4203797299824684143L;
    protected String host;
    protected String newsgroup;

    public NewsAddress() {
    }

    public NewsAddress(String newsgroup) {
        this.newsgroup = newsgroup;
    }

    public NewsAddress(String newsgroup, String host) {
        this.newsgroup = newsgroup;
        this.host = host;
    }

    public String getType() {
        return "news";
    }

    public void setNewsgroup(String newsgroup) {
        this.newsgroup = newsgroup;
    }

    public String getNewsgroup() {
        return this.newsgroup;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return this.newsgroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NewsAddress)) {
            return false;
        }
        NewsAddress newsAddress = (NewsAddress)o;
        if (this.host != null ? !this.host.equals(newsAddress.host) : newsAddress.host != null) {
            return false;
        }
        return !(this.newsgroup != null ? !this.newsgroup.equals(newsAddress.newsgroup) : newsAddress.newsgroup != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.toLowerCase().hashCode() : 0;
        result = 29 * result + (this.newsgroup != null ? this.newsgroup.hashCode() : 0);
        return result;
    }

    public static NewsAddress[] parse(String addresses) throws AddressException {
        ArrayList<NewsAddress> result = new ArrayList<NewsAddress>();
        StringTokenizer tokenizer = new StringTokenizer(addresses, ",");
        while (tokenizer.hasMoreTokens()) {
            String address = tokenizer.nextToken().trim();
            int index = address.indexOf(64);
            if (index == -1) {
                result.add(new NewsAddress(address));
                continue;
            }
            String newsgroup = address.substring(0, index).trim();
            String host = address.substring(index + 1).trim();
            result.add(new NewsAddress(newsgroup, host));
        }
        return result.toArray(new NewsAddress[result.size()]);
    }

    public static String toString(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(addresses.length * 32);
        result.append(addresses[0]);
        for (int i = 1; i < addresses.length; ++i) {
            result.append(',').append(addresses[i].toString());
        }
        return result.toString();
    }
}

