/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.HashSumEventStream;
import opennlp.tools.util.ObjectStream;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    @Override
    public void index(ObjectStream<Event> eventStream) throws IOException {
        List<ComparableEvent> eventsToCompare;
        int numEvents;
        int cutoff = this.trainingParameters.getIntParameter("Cutoff", 5);
        boolean sort = this.trainingParameters.getBooleanParameter("sort", true);
        long start = System.currentTimeMillis();
        this.display("Indexing events with TwoPass using cutoff of " + cutoff + "\n\n");
        this.display("\tComputing event counts...  ");
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        File tmp = File.createTempFile("events", null);
        tmp.deleteOnExit();
        HashSumEventStream writeEventStream = new HashSumEventStream(eventStream);
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmp)));){
            numEvents = this.computeEventCounts(writeEventStream, dos, predicateIndex, cutoff);
        }
        BigInteger writeHash = writeEventStream.calculateHashSum();
        this.display("done. " + numEvents + " events\n");
        this.display("\tIndexing...  ");
        BigInteger readHash = null;
        try (HashSumEventStream readStream = new HashSumEventStream(new EventStream(tmp));){
            eventsToCompare = this.index(readStream, predicateIndex);
            readHash = readStream.calculateHashSum();
        }
        tmp.delete();
        if (readHash.compareTo(writeHash) != 0) {
            throw new IOException("Event hash for writing and reading events did not match.");
        }
        this.display("done.\n");
        if (sort) {
            this.display("Sorting and merging events... ");
        } else {
            this.display("Collecting events... ");
        }
        this.sortAndMerge(eventsToCompare, sort);
        this.display(String.format("Done indexing in %.2f s.\n", (double)(System.currentTimeMillis() - start) / 1000.0));
    }

    /*
     * WARNING - void declaration
     */
    private int computeEventCounts(ObjectStream<Event> eventStream, DataOutputStream eventStore, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        void var9_13;
        Event ev;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        int eventCount = 0;
        while ((ev = eventStream.read()) != null) {
            ++eventCount;
            eventStore.writeUTF(ev.getOutcome());
            eventStore.writeInt(ev.getContext().length);
            String[] ec = ev.getContext();
            TwoPassDataIndexer.update(ec, counter);
            for (String ctxString : ec) {
                eventStore.writeUTF(ctxString);
            }
            if (ev.getValues() == null) {
                eventStore.writeInt(0);
                continue;
            }
            eventStore.writeInt(ev.getValues().length);
            for (float value : ev.getValues()) {
                eventStore.writeFloat(value);
            }
        }
        String[] predicateSet = (String[])counter.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= cutoff).map(Map.Entry::getKey).sorted().toArray(String[]::new);
        this.predCounts = new int[predicateSet.length];
        boolean bl = false;
        while (var9_13 < predicateSet.length) {
            this.predCounts[var9_13] = (Integer)counter.get(predicateSet[var9_13]);
            predicatesInOut.put(predicateSet[var9_13], (int)var9_13);
            ++var9_13;
        }
        return eventCount;
    }

    private static class EventStream
    implements ObjectStream<Event> {
        private final DataInputStream inputStream;

        public EventStream(File file) throws IOException {
            this.inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }

        @Override
        public Event read() throws IOException {
            if (this.inputStream.available() != 0) {
                String outcome = this.inputStream.readUTF();
                int contextLenght = this.inputStream.readInt();
                String[] context = new String[contextLenght];
                for (int i = 0; i < contextLenght; ++i) {
                    context[i] = this.inputStream.readUTF();
                }
                int valuesLength = this.inputStream.readInt();
                float[] values = null;
                if (valuesLength > 0) {
                    values = new float[valuesLength];
                    for (int i = 0; i < valuesLength; ++i) {
                        values[i] = this.inputStream.readFloat();
                    }
                }
                return new Event(outcome, context, values);
            }
            return null;
        }

        @Override
        public void reset() throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

