/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.ErrorEventHandler;
import org.apache.kafka.clients.consumer.internals.GroupState;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class DefaultBackgroundThread
extends KafkaThread {
    private static final long MAX_POLL_TIMEOUT_MS = 5000L;
    private static final String BACKGROUND_THREAD_NAME = "consumer_background_thread";
    private final Time time;
    private final Logger log;
    private final BlockingQueue<ApplicationEvent> applicationEventQueue;
    private final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private final ConsumerMetadata metadata;
    private final ConsumerConfig config;
    private final ApplicationEventProcessor applicationEventProcessor;
    private final NetworkClientDelegate networkClientDelegate;
    private final ErrorEventHandler errorEventHandler;
    private final GroupState groupState;
    private final SubscriptionState subscriptionState;
    private boolean running;
    private final Map<RequestManager.Type, Optional<RequestManager>> requestManagerRegistry;

    DefaultBackgroundThread(Time time, ConsumerConfig config, LogContext logContext, BlockingQueue<ApplicationEvent> applicationEventQueue, BlockingQueue<BackgroundEvent> backgroundEventQueue, SubscriptionState subscriptionState, ErrorEventHandler errorEventHandler, ApplicationEventProcessor processor, ConsumerMetadata metadata, NetworkClientDelegate networkClient, GroupState groupState, CoordinatorRequestManager coordinatorManager, CommitRequestManager commitRequestManager) {
        super(BACKGROUND_THREAD_NAME, true);
        this.time = time;
        this.running = true;
        this.log = logContext.logger(this.getClass());
        this.applicationEventQueue = applicationEventQueue;
        this.backgroundEventQueue = backgroundEventQueue;
        this.applicationEventProcessor = processor;
        this.config = config;
        this.metadata = metadata;
        this.networkClientDelegate = networkClient;
        this.errorEventHandler = errorEventHandler;
        this.groupState = groupState;
        this.subscriptionState = subscriptionState;
        this.requestManagerRegistry = new HashMap<RequestManager.Type, Optional<RequestManager>>();
        this.requestManagerRegistry.put(RequestManager.Type.COORDINATOR, Optional.ofNullable(coordinatorManager));
        this.requestManagerRegistry.put(RequestManager.Type.COMMIT, Optional.ofNullable(commitRequestManager));
    }

    public DefaultBackgroundThread(Time time, ConsumerConfig config, GroupRebalanceConfig rebalanceConfig, LogContext logContext, BlockingQueue<ApplicationEvent> applicationEventQueue, BlockingQueue<BackgroundEvent> backgroundEventQueue, ConsumerMetadata metadata, SubscriptionState subscriptionState, ApiVersions apiVersions, Metrics metrics, Sensor fetcherThrottleTimeSensor) {
        super(BACKGROUND_THREAD_NAME, true);
        Objects.requireNonNull(config);
        Objects.requireNonNull(rebalanceConfig);
        Objects.requireNonNull(logContext);
        Objects.requireNonNull(applicationEventQueue);
        Objects.requireNonNull(backgroundEventQueue);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(subscriptionState);
        try {
            this.time = time;
            this.log = logContext.logger(this.getClass());
            this.applicationEventQueue = applicationEventQueue;
            this.backgroundEventQueue = backgroundEventQueue;
            this.subscriptionState = subscriptionState;
            this.config = config;
            this.metadata = metadata;
            NetworkClient networkClient = ClientUtils.createNetworkClient(config, metrics, "consumer", logContext, apiVersions, time, 100, metadata, fetcherThrottleTimeSensor);
            this.networkClientDelegate = new NetworkClientDelegate(this.time, this.config, logContext, networkClient);
            this.running = true;
            this.errorEventHandler = new ErrorEventHandler(this.backgroundEventQueue);
            this.groupState = new GroupState(rebalanceConfig);
            this.requestManagerRegistry = Collections.unmodifiableMap(this.buildRequestManagerRegistry(logContext));
            this.applicationEventProcessor = new ApplicationEventProcessor(backgroundEventQueue, this.requestManagerRegistry, metadata);
        }
        catch (Exception e) {
            this.close();
            throw new KafkaException("Failed to construct background processor", e.getCause());
        }
    }

    private Map<RequestManager.Type, Optional<RequestManager>> buildRequestManagerRegistry(LogContext logContext) {
        HashMap<RequestManager.Type, Optional<RequestManager>> registry = new HashMap<RequestManager.Type, Optional<RequestManager>>();
        CoordinatorRequestManager coordinatorManager = this.groupState.groupId == null ? null : new CoordinatorRequestManager(this.time, logContext, this.config.getLong("retry.backoff.ms"), this.errorEventHandler, this.groupState.groupId);
        CommitRequestManager commitRequestManager = coordinatorManager == null ? null : new CommitRequestManager(this.time, logContext, this.subscriptionState, this.config, coordinatorManager, this.groupState);
        registry.put(RequestManager.Type.COORDINATOR, Optional.ofNullable(coordinatorManager));
        registry.put(RequestManager.Type.COMMIT, Optional.ofNullable(commitRequestManager));
        return registry;
    }

    @Override
    public void run() {
        try {
            this.log.debug("Background thread started");
            while (this.running) {
                try {
                    this.runOnce();
                }
                catch (WakeupException e) {
                    this.log.debug("WakeupException caught, background thread won't be interrupted");
                }
            }
        }
        catch (Throwable t) {
            this.log.error("The background thread failed due to unexpected error", t);
            throw new RuntimeException(t);
        }
        finally {
            this.close();
            this.log.debug("{} closed", this.getClass());
        }
    }

    void runOnce() {
        this.drain();
        long currentTimeMs = this.time.milliseconds();
        long pollWaitTimeMs = this.requestManagerRegistry.values().stream().filter(Optional::isPresent).map(m -> ((RequestManager)m.get()).poll(currentTimeMs)).map(this::handlePollResult).reduce(5000L, Math::min);
        this.networkClientDelegate.poll(pollWaitTimeMs, currentTimeMs);
    }

    private void drain() {
        Queue<ApplicationEvent> events = this.pollApplicationEvent();
        for (ApplicationEvent event : events) {
            this.log.debug("Consuming application event: {}", (Object)event);
            this.consumeApplicationEvent(event);
        }
    }

    long handlePollResult(NetworkClientDelegate.PollResult res) {
        if (!res.unsentRequests.isEmpty()) {
            this.networkClientDelegate.addAll(res.unsentRequests);
        }
        return res.timeUntilNextPollMs;
    }

    private Queue<ApplicationEvent> pollApplicationEvent() {
        if (this.applicationEventQueue.isEmpty()) {
            return new LinkedList<ApplicationEvent>();
        }
        LinkedList<ApplicationEvent> res = new LinkedList<ApplicationEvent>();
        this.applicationEventQueue.drainTo(res);
        return res;
    }

    private void consumeApplicationEvent(ApplicationEvent event) {
        Objects.requireNonNull(event);
        this.applicationEventProcessor.process(event);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void wakeup() {
        this.networkClientDelegate.wakeup();
    }

    public void close() {
        this.running = false;
        this.wakeup();
        Utils.closeQuietly(this.networkClientDelegate, "network client utils");
        Utils.closeQuietly(this.metadata, "consumer metadata client");
    }
}

