/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.opennlp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.Span;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.agents.transformation.opennlp.Messages;
import org.apache.manifoldcf.agents.transformation.opennlp.OpenNlpExtractorConfig;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class OpenNlpExtractor
extends BaseTransformationConnector {
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_OPENNLP_HTML = "editSpecification_OpenNLP.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    protected static int maximumExtractionCharacters = 524288;
    private static final String PERSONS = "ner_people";
    private static final String LOCATIONS = "ner_locations";
    private static final String ORGANIZATIONS = "ner_organizations";
    protected static final String ACTIVITY_EXTRACT = "extract";
    protected static final String[] activitiesList = new String[]{"extract"};
    protected final File fileDirectory = ManifoldCF.getFileProperty((String)"org.apache.manifoldcf.fileresources");
    protected static final long inMemoryMaximumFile = 65536L;
    private static final Set<String> acceptableMimeTypes = new HashSet<String>();

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(os);
        return new VersionContext(sp.toPackedString(), this.params, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        Logging.agents.debug((Object)"Starting OpenNlp extraction");
        SpecPacker sp = new SpecPacker(pipelineDescription.getSpecification());
        try (DestinationStorage ds = document.getBinaryLength() <= 65536L ? new MemoryDestinationStorage((int)document.getBinaryLength()) : new FileDestinationStorage();){
            int n;
            long startTime = System.currentTimeMillis();
            String resultCode = "OK";
            String description = null;
            Long length = null;
            MetadataAccumulator ma = new MetadataAccumulator(sp, document.getBinaryLength());
            try {
                OutputStream os = ds.getOutputStream();
                try {
                    OutputStreamWriter w = new OutputStreamWriter(os, "utf-8");
                    try {
                        InputStreamReader r = new InputStreamReader(document.getBinaryStream(), "utf-8");
                        try {
                            int amt;
                            char[] characterBuffer = new char[65536];
                            while ((amt = r.read(characterBuffer)) != -1) {
                                ((Writer)w).write(characterBuffer, 0, amt);
                                ma.acceptCharacters(characterBuffer, amt);
                            }
                        }
                        catch (IOException e) {
                            resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                            description = e.getMessage();
                            throw e;
                        }
                    }
                    finally {
                        ((Writer)w).flush();
                    }
                }
                finally {
                    os.close();
                    length = new Long(ds.getBinaryLength());
                }
            }
            catch (Throwable throwable) {
                activities.recordActivity(new Long(startTime), ACTIVITY_EXTRACT, length, documentURI, resultCode, description);
                throw throwable;
            }
            activities.recordActivity(new Long(startTime), ACTIVITY_EXTRACT, length, documentURI, resultCode, description);
            ma.done();
            RepositoryDocument docCopy = document.duplicate();
            long newBinaryLength = ds.getBinaryLength();
            InputStream is = ds.getInputStream();
            try {
                docCopy.setBinary(is, newBinaryLength);
                Map<String, Set<String>> nerMap = ma.getMetadata();
                if (!nerMap.isEmpty()) {
                    for (Map.Entry<String, Set<String>> entry : nerMap.entrySet()) {
                        Set<String> neList = entry.getValue();
                        String[] neArray = neList.toArray(new String[0]);
                        docCopy.addField(entry.getKey(), neArray);
                    }
                }
                n = activities.sendDocument(documentURI, docCopy);
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return n;
        }
    }

    public boolean checkMimeTypeIndexable(VersionContext pipelineDescription, String mimeType, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        if (mimeType == null || !acceptableMimeTypes.contains(mimeType.toLowerCase(Locale.ROOT))) {
            return false;
        }
        return super.checkMimeTypeIndexable(pipelineDescription, mimeType, checkActivity);
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "OpenNlpExtractor.OpenNLPTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        OpenNlpExtractor.fillInOpenNLPSpecificationMap(paramMap, os);
        this.setUpOpenNLPSpecificationMap(paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_OPENNLP_HTML, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        SpecificationNode node = new SpecificationNode("SModelPath");
        String smodelPath = variableContext.getParameter(seqPrefix + "smodelpath");
        if (smodelPath != null) {
            node.setAttribute("value", smodelPath);
        } else {
            node.setAttribute("value", "");
        }
        os.addChild(os.getChildCount(), (ConfigurationNode)node);
        node = new SpecificationNode("TModelPath");
        String tmodelPath = variableContext.getParameter(seqPrefix + "tmodelpath");
        if (tmodelPath != null) {
            node.setAttribute("value", tmodelPath);
        } else {
            node.setAttribute("value", "");
        }
        os.addChild(os.getChildCount(), (ConfigurationNode)node);
        String modelCount = variableContext.getParameter(seqPrefix + "model_count");
        if (modelCount != null) {
            int count = Integer.parseInt(modelCount);
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode cn = os.getChild(i);
                if (cn.getType().equals("FinderModel")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            for (int j = 0; j < count; ++j) {
                String op = variableContext.getParameter(seqPrefix + "model_" + j + "_op");
                if (op != null && op.equals("Delete")) continue;
                String paramName = variableContext.getParameter(seqPrefix + "model_" + j + "_parametername");
                String modelFile = variableContext.getParameter(seqPrefix + "model_" + j + "_modelfile");
                SpecificationNode sn = new SpecificationNode("FinderModel");
                sn.setAttribute("parametername", paramName);
                sn.setAttribute("modelfile", modelFile);
                os.addChild(os.getChildCount(), (ConfigurationNode)sn);
            }
            String addOp = variableContext.getParameter(seqPrefix + "model_op");
            if (addOp != null && addOp.equals("Add")) {
                String paramName = variableContext.getParameter(seqPrefix + "model_parametername");
                String modelFile = variableContext.getParameter(seqPrefix + "model_modelfile");
                SpecificationNode sn = new SpecificationNode("FinderModel");
                sn.setAttribute("parametername", paramName);
                sn.setAttribute("modelfile", modelFile);
                os.addChild(os.getChildCount(), (ConfigurationNode)sn);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        OpenNlpExtractor.fillInOpenNLPSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, paramMap);
    }

    protected void setUpOpenNLPSpecificationMap(Map<String, Object> paramMap) throws ManifoldCFException {
        String[] fileNames = this.getModelList();
        paramMap.put("FILENAMES", fileNames);
    }

    protected static void fillInOpenNLPSpecificationMap(Map<String, Object> paramMap, Specification os) {
        String sModelPath = "";
        String tModelPath = "";
        ArrayList finderModels = new ArrayList();
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals("SModelPath")) {
                sModelPath = sn.getAttributeValue("value");
                if (sModelPath != null) continue;
                sModelPath = "";
                continue;
            }
            if (sn.getType().equals("TModelPath")) {
                tModelPath = sn.getAttributeValue("value");
                if (tModelPath != null) continue;
                tModelPath = "";
                continue;
            }
            if (!sn.getType().equals("FinderModel")) continue;
            String parameterName = sn.getAttributeValue("parametername");
            String modelFile = sn.getAttributeValue("modelfile");
            HashMap<String, String> modelRecord = new HashMap<String, String>();
            modelRecord.put("parametername", parameterName);
            modelRecord.put("modelfile", modelFile);
            finderModels.add(modelRecord);
        }
        paramMap.put("SMODELPATH", sModelPath);
        paramMap.put("TMODELPATH", tModelPath);
        paramMap.put("MODELS", finderModels);
    }

    protected static int handleIOException(IOException e) throws ManifoldCFException {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected String[] getModelList() throws ManifoldCFException {
        if (this.fileDirectory == null) {
            return new String[0];
        }
        Object[] files = this.fileDirectory.list(new FileFilter());
        Arrays.sort(files);
        return files;
    }

    static {
        acceptableMimeTypes.add("text/plain;charset=utf-8");
        acceptableMimeTypes.add("text/plain;charset=ascii");
        acceptableMimeTypes.add("text/plain;charset=us-ascii");
        acceptableMimeTypes.add("text/plain");
    }

    protected static class SpecPacker {
        private final String sModelPath;
        private final String tModelPath;
        private final Map<String, String> models = new TreeMap<String, String>();

        public SpecPacker(Specification os) {
            String sModelPath = null;
            String tModelPath = null;
            for (int i = 0; i < os.getChildCount(); ++i) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("SModelPath")) {
                    sModelPath = sn.getAttributeValue("value");
                }
                if (sn.getType().equals("TModelPath")) {
                    tModelPath = sn.getAttributeValue("value");
                }
                if (!sn.getType().equals("FinderModel")) continue;
                String parameterName = sn.getAttributeValue("parametername");
                String modelFile = sn.getAttributeValue("modelfile");
                this.models.put(parameterName, modelFile);
            }
            this.sModelPath = sModelPath;
            this.tModelPath = tModelPath;
        }

        public String toPackedString() {
            StringBuilder sb = new StringBuilder();
            if (this.sModelPath != null) {
                sb.append(this.sModelPath);
            }
            sb.append(",");
            if (this.tModelPath != null) {
                sb.append(this.tModelPath);
            }
            sb.append("[");
            for (String parameterName : this.models.keySet()) {
                sb.append(parameterName).append("=").append(this.models.get(parameterName)).append(",");
            }
            return sb.toString();
        }

        public String getSModelPath() {
            return this.sModelPath;
        }

        public String getTModelPath() {
            return this.tModelPath;
        }

        public Map<String, String> getFinderModels() {
            return this.models;
        }
    }

    protected static class MemoryDestinationStorage
    implements DestinationStorage {
        protected final ByteArrayOutputStream outputStream;

        public MemoryDestinationStorage(int sizeHint) {
            this.outputStream = new ByteArrayOutputStream(sizeHint);
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputStream.size();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public void close() throws ManifoldCFException {
        }
    }

    protected static class FileDestinationStorage
    implements DestinationStorage {
        protected final File outputFile;
        protected final OutputStream outputStream;

        public FileDestinationStorage() throws ManifoldCFException {
            FileOutputStream outputStream;
            File outputFile;
            try {
                outputFile = File.createTempFile("mcftika", "tmp");
                outputStream = new FileOutputStream(outputFile);
            }
            catch (IOException e) {
                OpenNlpExtractor.handleIOException(e);
                outputFile = null;
                outputStream = null;
            }
            this.outputFile = outputFile;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputFile.length();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            try {
                return new FileInputStream(this.outputFile);
            }
            catch (IOException e) {
                OpenNlpExtractor.handleIOException(e);
                return null;
            }
        }

        @Override
        public void close() throws ManifoldCFException {
            this.outputFile.delete();
        }
    }

    protected static interface DestinationStorage {
        public OutputStream getOutputStream() throws ManifoldCFException;

        public long getBinaryLength() throws ManifoldCFException;

        public InputStream getInputStream() throws ManifoldCFException;

        public void close() throws ManifoldCFException;
    }

    protected class MetadataAccumulator {
        char[] characterBuffer = null;
        int bufferPointer = 0;
        final int bufferSize;
        final SentenceDetector sentenceDetector;
        final Tokenizer tokenizer;
        final Map<String, NameFinderME> finders = new HashMap<String, NameFinderME>();
        final Map<String, Set<String>> tokenLists = new HashMap<String, Set<String>>();

        public MetadataAccumulator(SpecPacker sp, long bytesize) throws ManifoldCFException {
            try {
                this.sentenceDetector = OpenNlpExtractorConfig.sentenceDetector(new File(OpenNlpExtractor.this.fileDirectory, sp.getSModelPath()));
                this.tokenizer = OpenNlpExtractorConfig.tokenizer(new File(OpenNlpExtractor.this.fileDirectory, sp.getTModelPath()));
                Map<String, String> finderFiles = sp.getFinderModels();
                for (String paramName : finderFiles.keySet()) {
                    this.finders.put(paramName, OpenNlpExtractorConfig.finder(new File(OpenNlpExtractor.this.fileDirectory, finderFiles.get(paramName))));
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            this.bufferSize = bytesize > (long)maximumExtractionCharacters ? maximumExtractionCharacters : (int)bytesize;
        }

        public void acceptCharacters(char[] buffer, int amt) {
            if (this.characterBuffer == null) {
                this.characterBuffer = new char[this.bufferSize];
            }
            int sourcePtr = 0;
            for (int copyAmt = amt > this.bufferSize - this.bufferPointer ? this.bufferSize - this.bufferPointer : amt; copyAmt > 0; --copyAmt) {
                this.characterBuffer[this.bufferPointer++] = buffer[sourcePtr++];
            }
        }

        public void done() {
            String[] sentences;
            if (this.bufferPointer == 0 || this.characterBuffer == null) {
                return;
            }
            String textContent = new String(this.characterBuffer, 0, this.bufferPointer);
            for (String sentence : sentences = this.sentenceDetector.sentDetect(textContent)) {
                String[] tokens = this.tokenizer.tokenize(sentence);
                for (String parameterName : this.finders.keySet()) {
                    Set<String> stringSet = this.tokenLists.get(parameterName);
                    if (stringSet == null) {
                        stringSet = new HashSet<String>();
                        this.tokenLists.put(parameterName, stringSet);
                    }
                    Span[] spans = this.finders.get(parameterName).find(tokens);
                    stringSet.addAll(Arrays.asList(Span.spansToStrings((Span[])spans, (String[])tokens)));
                }
            }
        }

        public Map<String, Set<String>> getMetadata() {
            return this.tokenLists;
        }
    }

    protected static class FileFilter
    implements FilenameFilter {
        protected FileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return new File(dir, name).isFile();
        }
    }
}

