/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.boxes.FullBox;
import com.drew.metadata.mp4.media.Mp4SoundDirectory;
import com.drew.metadata.mp4.media.Mp4VideoDirectory;
import java.io.IOException;
import java.util.ArrayList;

public class TimeToSampleBox
extends FullBox {
    private long entryCount;
    private ArrayList<EntryCount> entries;

    public TimeToSampleBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        this.entryCount = reader.getUInt32();
        this.entries = new ArrayList();
        int i = 0;
        while ((long)i < this.entryCount) {
            this.entries.add(new EntryCount(reader.getUInt32(), reader.getUInt32()));
            ++i;
        }
    }

    public void addMetadata(Mp4VideoDirectory directory, Mp4Context context) {
        float sampleCount = 0.0f;
        for (EntryCount ec : this.entries) {
            sampleCount += (float)ec.sampleCount;
        }
        float frameRate = (float)context.timeScale.longValue() / ((float)context.duration.longValue() / sampleCount);
        directory.setFloat(214, frameRate);
    }

    public void addMetadata(Mp4SoundDirectory directory, Mp4Context context) {
        directory.setDouble(304, context.timeScale.longValue());
    }

    static class EntryCount {
        long sampleCount;
        long sampleDelta;

        public EntryCount(long sampleCount, long sampleDelta) {
            this.sampleCount = sampleCount;
            this.sampleDelta = sampleDelta;
        }
    }
}

