/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.EnumSet;
import java.util.Set;

public enum FunctionProperty {
    INVERTIBLE,
    INJECTIVE,
    SURJECTIVE,
    ORDER_PRESERVING,
    ORDER_REVERSING;

    private static final EnumSet<FunctionProperty> BIJECTIVE;

    public static boolean isBijective(Set<FunctionProperty> set) {
        return set.containsAll(BIJECTIVE);
    }

    public static boolean isMonotonic(Set<FunctionProperty> set) {
        return set.contains((Object)ORDER_PRESERVING) || set.contains((Object)ORDER_REVERSING);
    }

    static {
        BIJECTIVE = EnumSet.of(INJECTIVE, SURJECTIVE);
    }
}

