/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Locale;

public enum GeometryType {
    GEOMETRY,
    POINT,
    LINESTRING,
    POLYGON,
    MULTI_POINT,
    MULTI_LINESTRING,
    MULTI_POLYGON,
    GEOMETRY_COLLECTION;


    public final int binaryType() {
        return this.ordinal();
    }

    public final boolean isCollection() {
        return this.ordinal() >= MULTI_POINT.ordinal();
    }

    public static GeometryType forName(String string) {
        int n;
        if (string != null && (n = (string = string.trim().toUpperCase(Locale.US)).length()) > 0) {
            if (string.charAt(n - 1) == 'M') {
                --n;
            }
            if (n > 0 && string.charAt(n - 1) == 'Z') {
                --n;
            }
            switch (string = string.substring(0, n)) {
                case "MULTIPOINT": {
                    return MULTI_POINT;
                }
                case "MULTILINESTRING": {
                    return MULTI_LINESTRING;
                }
                case "MULTIPOLYGON": {
                    return MULTI_POLYGON;
                }
                case "GEOMCOLLECTION": {
                    return GEOMETRY_COLLECTION;
                }
            }
            return GeometryType.valueOf(string);
        }
        return null;
    }

    public static GeometryType forBinaryType(int n) {
        if (n >= 1000 && n < 4000) {
            n %= 1000;
        }
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return GEOMETRY;
            }
            case 1: {
                return POINT;
            }
            case 2: {
                return LINESTRING;
            }
            case 3: {
                return POLYGON;
            }
            case 4: {
                return MULTI_POINT;
            }
            case 5: {
                return MULTI_LINESTRING;
            }
            case 6: {
                return MULTI_POLYGON;
            }
            case 7: 
        }
        return GEOMETRY_COLLECTION;
    }
}

