/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

final class RecoloredImage
extends ImageAdapter {
    private final ColorModel colors;

    private RecoloredImage(RenderedImage renderedImage, ColorModel colorModel) {
        super(renderedImage);
        this.colors = colorModel;
    }

    static RenderedImage create(RenderedImage renderedImage, ColorModel colorModel) {
        if (colorModel == null) {
            return renderedImage;
        }
        while (true) {
            if (colorModel.equals(renderedImage.getColorModel())) {
                return renderedImage;
            }
            if (!(renderedImage instanceof RecoloredImage)) break;
            renderedImage = ((RecoloredImage)renderedImage).source;
        }
        return ImageProcessor.unique(new RecoloredImage(renderedImage, colorModel));
    }

    static RenderedImage stretchColorRamp(ImageProcessor imageProcessor, RenderedImage renderedImage, Map<String, ?> map) {
        ColorModel colorModel;
        Object object;
        Number number;
        int n = ImageUtilities.getVisibleBand(renderedImage);
        if (n < 0) {
            return renderedImage;
        }
        RenderedImage renderedImage2 = renderedImage;
        Statistics[] statisticsArray = null;
        Statistics statistics = null;
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.POSITIVE_INFINITY;
        SampleDimension sampleDimension = null;
        if (map != null) {
            number = Containers.property(map, "minimum", Number.class);
            object = Containers.property(map, "maximum", Number.class);
            if (number != null) {
                d = number.doubleValue();
            }
            if (object != null) {
                d2 = ((Number)object).doubleValue();
            }
            if (d >= d2) {
                throw new IllegalArgumentException(Errors.format((short)60, number, object));
            }
            Number number2 = Containers.property(map, "multStdDev", Number.class);
            if (number2 != null) {
                d3 = number2.doubleValue();
                ArgumentChecks.ensureStrictlyPositive("multStdDev", d3);
            }
            if ((number2 = map.get("statistics")) != null) {
                if (number2 instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)((Object)number2);
                } else if (number2 instanceof Statistics) {
                    statistics = (Statistics)((Object)number2);
                } else if (number2 instanceof Statistics[]) {
                    statisticsArray = (Statistics[])number2;
                } else {
                    throw RecoloredImage.illegalPropertyType(map, "statistics", number2);
                }
            }
            if ((number2 = map.get("sampleDimensions")) != null) {
                List list;
                if (number2 instanceof List && n < (list = (List)((Object)number2)).size()) {
                    number2 = list.get(n);
                }
                if (number2 != null) {
                    if (number2 instanceof SampleDimension) {
                        sampleDimension = (SampleDimension)((Object)number2);
                    } else {
                        throw RecoloredImage.illegalPropertyType(map, "sampleDimensions", number2);
                    }
                }
            }
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            if (statistics == null) {
                if (statisticsArray == null) {
                    number = map.get("areaOfInterest");
                    statisticsArray = imageProcessor.valueOfStatistics(renderedImage2, number instanceof Shape ? (Shape)((Object)number) : null);
                }
                if (statisticsArray != null && n < statisticsArray.length) {
                    statistics = statisticsArray[n];
                }
            }
            if (statistics != null) {
                d3 *= statistics.standardDeviation(true);
                double d4 = statistics.mean();
                if (Double.isNaN(d)) {
                    d = Math.max(statistics.minimum(), d4 - d3);
                }
                if (Double.isNaN(d2)) {
                    d2 = Math.min(statistics.maximum(), d4 + d3);
                }
            }
        }
        if (!(d < d2)) {
            return renderedImage;
        }
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            Object object2;
            object = (IndexColorModel)renderedImage.getColorModel();
            int n2 = ((IndexColorModel)object).getMapSize();
            int n3 = 0;
            int n4 = n2 - 1;
            double d5 = 0.0;
            if (sampleDimension != null) {
                for (Category category : sampleDimension.getCategories()) {
                    if (!category.isQuantitative()) continue;
                    object2 = category.getSampleRange();
                    double d6 = Math.max(((NumberRange)object2).getMinDouble(true), 0.0);
                    double d7 = Math.min(((NumberRange)object2).getMaxDouble(true), (double)(n2 - 1));
                    double d8 = Math.min(d7, d2) - Math.max(d6, d);
                    if (!(d8 > d5)) continue;
                    n3 = (int)d6;
                    n4 = (int)d7;
                    d5 = d8;
                }
            }
            int n5 = Math.max(Math.min((int)d2, n4), n3);
            int n6 = Math.min(Math.max((int)d, n3), n5);
            object2 = new int[n2];
            ((IndexColorModel)object).getRGBs((int[])object2);
            Arrays.fill((int[])object2, n3, n6, ((IndexColorModel)object).getRGB(n3));
            Arrays.fill((int[])object2, n5 + 1, n4, ((IndexColorModel)object).getRGB(n4));
            float f = (float)((double)(n4 - n3) / (d2 - d));
            for (int i = n6; i <= n5; ++i) {
                float f2 = (float)(i - n6) * f + (float)n3;
                object2[i] = ((IndexColorModel)object).getRGB(Math.round(f2));
            }
            SampleModel sampleModel = renderedImage.getSampleModel();
            colorModel = ColorModelFactory.createIndexColorModel(sampleModel.getNumBands(), n, (int[])object2, ((ColorModel)object).hasAlpha(), ((IndexColorModel)object).getTransparentPixel());
        } else {
            object = renderedImage.getSampleModel();
            colorModel = ColorModelFactory.createGrayScale(((SampleModel)object).getDataType(), ((SampleModel)object).getNumBands(), n, d, d2);
        }
        return RecoloredImage.create(renderedImage, colorModel);
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> map, String string, Object object) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)58, string, object.getClass()));
    }

    @Override
    public ColorModel getColorModel() {
        return this.colors;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.colors.equals(((RecoloredImage)object).colors);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.colors.hashCode();
    }

    final Class<RecoloredImage> appendStringContent(StringBuilder stringBuilder) {
        stringBuilder.append(this.colors.getColorSpace());
        return RecoloredImage.class;
    }
}

