/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.nuxeo.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.crawler.connectors.nuxeo.model.NuxeoAttachment;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.Documents;
import org.nuxeo.client.objects.Operation;
import org.nuxeo.client.objects.acl.ACE;
import org.nuxeo.client.objects.acl.ACL;
import org.nuxeo.client.objects.blob.FileBlob;

public class NuxeoDocumentHelper {
    private static final String URI_TAGGING = "SELECT * FROM Tagging";
    private static final String DEFAULT_MIMETYPE = "text/html; charset=utf-8";
    private static final Set<String> AVOID_PROPERTIES = ImmutableSet.of((Object)"file:filename", (Object)"thumb:thumbnail", (Object)"file:content", (Object)"files:files");
    private Document document;
    private InputStream content;
    private int size;
    private String mimetype;
    private String filename;
    private Map<String, Object> properties = null;
    public static final String DELETED = "deleted";
    private static final String DOC_UID = "uid";
    private static final String DOC_ENTITY_TYPE = "entity-type";
    private static final String DOC_LAST_MODIFIED = "last-modified";
    private static final String DOC_STATE = "state";
    private static final String NUXEO_MAJOR_VERSION_PROPERTY = "uid:major_version";
    private static final String NUXEO_MINOR_VERSION_PROPERTY = "uid:minor_version";
    private static final Set<String> NUXEO_FOLDER_TYPE = ImmutableSet.of((Object)"Folderish", (Object)"Collection");
    private static final String NUXEO_TAGS_PROPERTY = "nxtag:tags";
    private static final byte[] EMPTY_BYTES = new byte[0];

    public NuxeoDocumentHelper(Document document) {
        this.document = document;
        this.processDocument();
    }

    public Map<String, Object> getMetadata() {
        HashMap docMetadata = Maps.newHashMap();
        for (Map.Entry<String, Object> property : this.getProperties().entrySet()) {
            if (AVOID_PROPERTIES.contains(property.getKey())) continue;
            try {
                if (property.getKey().equalsIgnoreCase(NUXEO_TAGS_PROPERTY)) {
                    List tags = (List)property.getValue();
                    ArrayList tagsLabels = Lists.newArrayList();
                    for (Map tag : tags) {
                        if (!tag.containsKey("label")) continue;
                        tagsLabels.add((String)tag.get("label"));
                        break;
                    }
                    if (tagsLabels.isEmpty()) continue;
                    docMetadata.put("tags", tagsLabels);
                    continue;
                }
                this.addIfNotEmpty(docMetadata, property.getKey(), property.getValue());
            }
            catch (Exception e) {}
        }
        this.addIfNotEmpty(docMetadata, DOC_UID, this.document.getUid());
        this.addIfNotEmpty(docMetadata, DOC_ENTITY_TYPE, this.document.getEntityType());
        this.addIfNotEmpty(docMetadata, DOC_LAST_MODIFIED, this.document.getLastModified());
        this.addIfNotEmpty(docMetadata, DOC_STATE, this.document.getState());
        return docMetadata;
    }

    public boolean isFolder() {
        return !Collections.disjoint(this.document.getFacets(), NUXEO_FOLDER_TYPE);
    }

    private void addIfNotEmpty(Map<String, Object> docMetadata, String key, Object obj) {
        if (obj != null && (obj instanceof String && !((String)obj).isEmpty() || !(obj instanceof String))) {
            docMetadata.put(key, obj);
        }
    }

    private void processDocument() {
        try {
            FileBlob blob = this.document.fetchBlob();
            this.content = blob.getStream();
            this.mimetype = blob.getMimeType();
            this.size = blob.getLength();
            this.filename = blob.getFilename();
        }
        catch (Exception ex) {
            this.content = new ByteArrayInputStream(EMPTY_BYTES);
            this.mimetype = DEFAULT_MIMETYPE;
            this.size = 0;
            this.filename = this.document.getTitle();
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public int getLength() {
        return this.size;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getFilename() {
        return this.filename;
    }

    private Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = this.document.getProperties();
        }
        return this.properties;
    }

    public String getVersion() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.document.getUid());
        builder.append('_');
        if (this.getProperties().containsKey(NUXEO_MAJOR_VERSION_PROPERTY) && this.getProperties().containsKey(NUXEO_MINOR_VERSION_PROPERTY)) {
            builder.append(this.getProperties().get(NUXEO_MAJOR_VERSION_PROPERTY));
            builder.append('.');
            builder.append(this.getProperties().get(NUXEO_MINOR_VERSION_PROPERTY));
        } else {
            builder.append("0.0");
        }
        return builder.toString();
    }

    public String[] getPermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        try {
            for (ACL acl : this.getDocument().fetchPermissions().getAcls()) {
                for (ACE ace : acl.getAces()) {
                    if (!ace.getStatus().equalsIgnoreCase("effective") || !ace.getGranted().equalsIgnoreCase("true")) continue;
                    permissions.add(ace.getUsername());
                }
            }
            return permissions.toArray(new String[permissions.size()]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public List<NuxeoAttachment> getAttachments(NuxeoClient nuxeoClient) {
        ArrayList<NuxeoAttachment> attachments = new ArrayList<NuxeoAttachment>();
        List arrayList = (List)this.document.getPropertyValue("files:files");
        for (Object object : arrayList) {
            NuxeoAttachment attach = new NuxeoAttachment();
            LinkedHashMap file = (LinkedHashMap)((LinkedHashMap)object).get("file");
            attach.name = (String)file.get("name");
            attach.encoding = (String)file.get("encoding");
            attach.mime_type = (String)file.get("mime-type");
            attach.digestAlgorithm = (String)file.get("digestAlgorithm");
            attach.digest = (String)file.get("digest");
            attach.length = Long.valueOf((String)file.get("length"));
            attach.url = (String)file.get("data");
            try {
                FileBlob blob = nuxeoClient.repository().fetchBlobById(this.document.getUid(), this.getAttachPath(attach.url));
                attach.data = blob.getStream();
            }
            catch (Exception ex) {
                attach.data = new ByteArrayInputStream(EMPTY_BYTES);
            }
            attachments.add(attach);
        }
        return attachments;
    }

    private String getAttachPath(String absolutePath) {
        String[] splitPath = absolutePath.split("/");
        int size = splitPath.length;
        return String.join((CharSequence)"/", splitPath[size - 4], splitPath[size - 3], splitPath[size - 2]);
    }

    public String[] getTags(NuxeoClient nuxeoClient) {
        try {
            Operation op = nuxeoClient.operation("Repository.Query").param("query", (Object)("SELECT * FROM Tagging where relation:source='" + this.document.getUid() + "'"));
            Documents tags = (Documents)op.execute();
            ArrayList<String> ls = new ArrayList<String>();
            for (Document tag : tags.getDocuments()) {
                ls.add(tag.getTitle());
            }
            return ls.toArray(new String[tags.size()]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }
}

