/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.io.IOException;
import java.io.Reader;
import org.apache.manifoldcf.scriptengine.ScriptException;

public class CharacterStream {
    protected Reader reader;
    protected int currentCharacter = -1;
    protected int lineNumber = 0;
    protected int characterNumber = 0;

    public CharacterStream(Reader reader) {
        this.reader = reader;
    }

    public int peek() throws ScriptException {
        if (this.currentCharacter == -1) {
            this.currentCharacter = this.readNextCharacter();
        }
        return this.currentCharacter;
    }

    public void skip() {
        this.currentCharacter = -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharacterNumber() {
        return this.characterNumber;
    }

    protected int readNextCharacter() throws ScriptException {
        if (this.reader == null) {
            return -1;
        }
        try {
            int rval = this.reader.read();
            if (rval == -1) {
                this.reader.close();
                this.reader = null;
                return -1;
            }
            ++this.characterNumber;
            if ((char)rval == '\n') {
                ++this.lineNumber;
                this.characterNumber = 0;
            }
            return rval;
        }
        catch (IOException e) {
            throw new ScriptException("I/O exception: " + e.getMessage(), e);
        }
    }
}

