/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.nullconnector;

import java.io.IOException;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class NullConnector
extends BaseTransformationConnector {
    public static final String _rcsid = "@(#)$Id$";
    protected static final String ACTIVITY_PROCESS = "process";
    protected static final String[] activitiesList = new String[]{"process"};

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        long startTime = System.currentTimeMillis();
        String resultCode = "OK";
        String description = null;
        Long length = null;
        try {
            long binaryLength = document.getBinaryLength();
            int rval = activities.sendDocument(documentURI, document);
            length = new Long(binaryLength);
            resultCode = rval == 0 ? "ACCEPTED" : "REJECTED";
            int n = rval;
            return n;
        }
        catch (ServiceInterruption e) {
            resultCode = "SERVICEINTERRUPTION";
            description = e.getMessage();
            throw e;
        }
        catch (ManifoldCFException e) {
            resultCode = "EXCEPTION";
            description = e.getMessage();
            throw e;
        }
        catch (IOException e) {
            resultCode = "IOEXCEPTION";
            description = e.getMessage();
            throw e;
        }
        finally {
            activities.recordActivity(new Long(startTime), ACTIVITY_PROCESS, length, documentURI, resultCode, description);
        }
    }
}

