/*
 * Decompiled with CFR 0.152.
 */
package org.htrace.wrappers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.htrace.Sampler;
import org.htrace.Trace;
import org.htrace.TraceScope;

public class TraceProxy {
    public static <T> T trace(T instance) {
        return TraceProxy.trace(instance, Sampler.ALWAYS);
    }

    public static <T, V> T trace(final T instance, final Sampler<V> sampler) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                if (!sampler.next(null)) {
                    return method.invoke(instance, args);
                }
                TraceScope scope = Trace.startSpan(method.getName(), Sampler.ALWAYS);
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                finally {
                    scope.close();
                }
            }
        };
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
    }
}

