/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.security.AccessController;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HBase"})
@InterfaceStability.Unstable
public class PlatformName {
    public static final String PLATFORM_NAME = (System.getProperty("os.name").startsWith("Windows") ? System.getenv("os") : System.getProperty("os.name")) + "-" + System.getProperty("os.arch") + "-" + System.getProperty("sun.arch.data.model");
    public static final String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
    public static final boolean IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM") && PlatformName.hasIbmTechnologyEditionModules();

    private static boolean hasIbmTechnologyEditionModules() {
        return Arrays.asList("com.ibm.security.auth.module.JAASLoginModule", "com.ibm.security.auth.module.Win64LoginModule", "com.ibm.security.auth.module.NTLoginModule", "com.ibm.security.auth.module.AIX64LoginModule", "com.ibm.security.auth.module.LinuxLoginModule", "com.ibm.security.auth.module.Krb5LoginModule").stream().anyMatch(module -> PlatformName.isSystemClassAvailable(module));
    }

    private static boolean isSystemClassAvailable(String className) {
        return AccessController.doPrivileged(() -> {
            try {
                new SystemClassAccessor().getSystemClass(className);
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        });
    }

    public static void main(String[] args) {
        System.out.println(PLATFORM_NAME);
    }

    private static final class SystemClassAccessor
    extends ClassLoader {
        private SystemClassAccessor() {
        }

        public Class<?> getSystemClass(String className) throws ClassNotFoundException {
            return this.findSystemClass(className);
        }
    }
}

