/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Algorithm;
import org.opengis.util.InternationalString;

@XmlType(name="LE_Algorithm_Type", propOrder={"citation", "description"})
@XmlRootElement(name="LE_Algorithm")
public class DefaultAlgorithm
extends ISOMetadata
implements Algorithm {
    private static final long serialVersionUID = 5718445163047946957L;
    private Citation citation;
    private InternationalString description;

    public DefaultAlgorithm() {
    }

    public DefaultAlgorithm(Algorithm algorithm) {
        super(algorithm);
        if (algorithm != null) {
            this.citation = algorithm.getCitation();
            this.description = algorithm.getDescription();
        }
    }

    public static DefaultAlgorithm castOrCopy(Algorithm algorithm) {
        if (algorithm == null || algorithm instanceof DefaultAlgorithm) {
            return (DefaultAlgorithm)algorithm;
        }
        return new DefaultAlgorithm(algorithm);
    }

    @XmlElement(name="citation", required=true)
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.checkWritePermission(this.citation);
        this.citation = citation;
    }

    @XmlElement(name="description", required=true)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission(this.description);
        this.description = internationalString;
    }
}

