/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.alias.LocalKeyStoreProvider;

@InterfaceAudience.Private
public final class LocalJavaKeyStoreProvider
extends LocalKeyStoreProvider {
    public static final String SCHEME_NAME = "localjceks";
    public static final String KEYSTORE_TYPE = "jceks";
    public static final String ALGORITHM = "AES";

    private LocalJavaKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected String getKeyStoreType() {
        return KEYSTORE_TYPE;
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (LocalJavaKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new LocalJavaKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

