/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.utils.DocNameExtractor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class SubmissionReport {
    private NumberFormat nf;
    private PrintWriter logger;
    private String name;
    private static String padd = "                                    ";

    public SubmissionReport(PrintWriter logger, String name) {
        this.logger = logger;
        this.name = name;
        this.nf = NumberFormat.getInstance(Locale.ROOT);
        this.nf.setMaximumFractionDigits(4);
        this.nf.setMinimumFractionDigits(4);
    }

    public void report(QualityQuery qq, TopDocs td, String docNameField, IndexSearcher searcher) throws IOException {
        if (this.logger == null) {
            return;
        }
        ScoreDoc[] sd = td.scoreDocs;
        String sep = " \t ";
        DocNameExtractor xt = new DocNameExtractor(docNameField);
        StoredFields storedFields = searcher.storedFields();
        for (int i = 0; i < sd.length; ++i) {
            String docName = xt.docName(storedFields, sd[i].doc);
            this.logger.println(qq.getQueryID() + sep + "Q0" + sep + this.format(docName, 20) + sep + this.format("" + i, 7) + sep + this.nf.format(sd[i].score) + sep + this.name);
        }
    }

    public void flush() {
        if (this.logger != null) {
            this.logger.flush();
        }
    }

    private String format(String s, int minLen) {
        s = s == null ? "" : s;
        int n = Math.max(minLen, s.length());
        return (s + padd).substring(0, n);
    }
}

