/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.CreateIndexTask;
import org.apache.lucene.benchmark.byTask.tasks.OpenReaderTask;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;

public class OpenIndexTask
extends PerfTask {
    public static final int DEFAULT_MAX_BUFFERED = -1;
    public static final int DEFAULT_MERGE_PFACTOR = 10;
    public static final double DEFAULT_RAM_FLUSH_MB = 16.0;
    private String commitUserData;

    public OpenIndexTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public int doLogic() throws IOException {
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        IndexCommit ic = this.commitUserData != null ? OpenReaderTask.findIndexCommit(runData.getDirectory(), this.commitUserData) : null;
        IndexWriter writer = CreateIndexTask.configureWriter(config, runData, IndexWriterConfig.OpenMode.APPEND, ic);
        runData.setIndexWriter(writer);
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        if (params != null) {
            this.commitUserData = params;
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

