/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.assertj.core.api.Assertions;

public class Compiler {
    public static void compile(File source, String ... compilerOptions) throws IOException {
        Compiler.compile(Collections.singletonList(source), compilerOptions);
    }

    public static void compile(Iterable<? extends File> sources, String ... compilerOptions) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> errors = new ArrayList<String>();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sources);
            List<String> options = Arrays.asList(compilerOptions);
            compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits).call();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(diagnostic.toString());
            }
        }
        Assertions.assertThat(errors).isEmpty();
    }
}

