/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.tojul;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.util.StackLocatorUtil;

final class LazyLog4jLogRecord
extends LogRecord {
    private static final long serialVersionUID = 6798134264543826471L;
    private transient boolean inferCaller = true;
    private final String fqcn;

    LazyLog4jLogRecord(String fqcn, Level level, String msg) {
        super(level, msg);
        this.fqcn = fqcn;
    }

    @Override
    public String getSourceClassName() {
        if (this.inferCaller) {
            this.inferCaller();
        }
        return super.getSourceClassName();
    }

    @Override
    public String getSourceMethodName() {
        if (this.inferCaller) {
            this.inferCaller();
        }
        return super.getSourceMethodName();
    }

    private void inferCaller() {
        StackTraceElement location = null;
        if (this.fqcn != null) {
            location = StackLocatorUtil.calcLocation((String)this.fqcn);
        }
        if (location != null) {
            this.setSourceClassName(location.getClassName());
            this.setSourceMethodName(location.getMethodName());
        } else {
            this.setSourceClassName(null);
            this.setSourceMethodName(null);
        }
        this.inferCaller = false;
    }
}

