/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteRule;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteRuleBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteRuleFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteSpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteSpecFluent<A extends HTTPRouteSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> hostnames = new ArrayList<String>();
    private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList();
    private ArrayList<HTTPRouteRuleBuilder> rules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteSpecFluent() {
    }

    public HTTPRouteSpecFluent(HTTPRouteSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPRouteSpec instance) {
        HTTPRouteSpec hTTPRouteSpec = instance = instance != null ? instance : new HTTPRouteSpec();
        if (instance != null) {
            this.withHostnames(instance.getHostnames());
            this.withParentRefs(instance.getParentRefs());
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)((Object)this);
    }

    public A setToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)((Object)this);
    }

    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHostnames(String ... items) {
        if (this.hostnames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hostnames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hostnames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public String getHostname(int index) {
        return this.hostnames.get(index);
    }

    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)((Object)this);
    }

    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
            this._visitables.remove((Object)"hostnames");
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    public A addToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get((Object)"parentRefs").add(index, builder);
            this.parentRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get((Object)"parentRefs").set(index, builder);
            this.parentRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").remove((Object)builder);
            this.parentRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").remove((Object)builder);
            this.parentRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        Iterator<ParentReferenceBuilder> each = this.parentRefs.iterator();
        List visitables = this._visitables.get((Object)"parentRefs");
        while (each.hasNext()) {
            ParentReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ParentReference> buildParentRefs() {
        return this.parentRefs != null ? HTTPRouteSpecFluent.build(this.parentRefs) : null;
    }

    public ParentReference buildParentRef(int index) {
        return this.parentRefs.get(index).build();
    }

    public ParentReference buildFirstParentRef() {
        return this.parentRefs.get(0).build();
    }

    public ParentReference buildLastParentRef() {
        return this.parentRefs.get(this.parentRefs.size() - 1).build();
    }

    public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParentRefs(List<ParentReference> parentRefs) {
        if (this.parentRefs != null) {
            this._visitables.get((Object)"parentRefs").clear();
        }
        if (parentRefs != null) {
            this.parentRefs = new ArrayList();
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        } else {
            this.parentRefs = null;
        }
        return (A)((Object)this);
    }

    public A withParentRefs(ParentReference ... parentRefs) {
        if (this.parentRefs != null) {
            this.parentRefs.clear();
            this._visitables.remove((Object)"parentRefs");
        }
        if (parentRefs != null) {
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParentRefs() {
        return this.parentRefs != null && !this.parentRefs.isEmpty();
    }

    public ParentRefsNested<A> addNewParentRef() {
        return new ParentRefsNested(-1, null);
    }

    public ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
        return new ParentRefsNested(-1, item);
    }

    public ParentRefsNested<A> setNewParentRefLike(int index, ParentReference item) {
        return new ParentRefsNested(index, item);
    }

    public ParentRefsNested<A> editParentRef(int index) {
        if (this.parentRefs.size() <= index) {
            throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public ParentRefsNested<A> editFirstParentRef() {
        if (this.parentRefs.size() == 0) {
            throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(0, this.buildParentRef(0));
    }

    public ParentRefsNested<A> editLastParentRef() {
        int index = this.parentRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parentRefs.size(); ++i) {
            if (!predicate.test(this.parentRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parentRefs. No match found.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public A addToRules(int index, HTTPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRules(int index, HTTPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(HTTPRouteRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRules(Collection<HTTPRouteRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRules(HTTPRouteRule ... items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRules(Collection<HTTPRouteRule> items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRules(Predicate<HTTPRouteRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPRouteRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            HTTPRouteRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPRouteRule> buildRules() {
        return this.rules != null ? HTTPRouteSpecFluent.build(this.rules) : null;
    }

    public HTTPRouteRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public HTTPRouteRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public HTTPRouteRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public HTTPRouteRule buildMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
        for (HTTPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
        for (HTTPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<HTTPRouteRule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (HTTPRouteRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)((Object)this);
    }

    public A withRules(HTTPRouteRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove((Object)"rules");
        }
        if (rules != null) {
            for (HTTPRouteRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(HTTPRouteRule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, HTTPRouteRule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteSpecFluent that = (HTTPRouteSpecFluent)((Object)o);
        if (!Objects.equals(this.hostnames, that.hostnames)) {
            return false;
        }
        if (!Objects.equals(this.parentRefs, that.parentRefs)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hostnames, this.parentRefs, this.rules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostnames != null && !this.hostnames.isEmpty()) {
            sb.append("hostnames:");
            sb.append(this.hostnames + ",");
        }
        if (this.parentRefs != null && !this.parentRefs.isEmpty()) {
            sb.append("parentRefs:");
            sb.append(this.parentRefs + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RulesNested<N>
    extends HTTPRouteRuleFluent<RulesNested<N>>
    implements Nested<N> {
        HTTPRouteRuleBuilder builder;
        int index;

        RulesNested(int index, HTTPRouteRule item) {
            this.index = index;
            this.builder = new HTTPRouteRuleBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteSpecFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class ParentRefsNested<N>
    extends ParentReferenceFluent<ParentRefsNested<N>>
    implements Nested<N> {
        ParentReferenceBuilder builder;
        int index;

        ParentRefsNested(int index, ParentReference item) {
            this.index = index;
            this.builder = new ParentReferenceBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteSpecFluent.this.setToParentRefs(this.index, this.builder.build());
        }

        public N endParentRef() {
            return this.and();
        }
    }
}

