/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.function.BooleanSupplier;

public class SettableBeanPropertyDelegate
extends SettableBeanProperty.Delegating {
    private final SettableAnyProperty anySetter;
    private final transient BooleanSupplier useAnySetter;

    SettableBeanPropertyDelegate(SettableBeanProperty delegate, SettableAnyProperty anySetter, BooleanSupplier useAnySetter) {
        super(delegate);
        this.anySetter = anySetter;
        this.useAnySetter = useAnySetter;
    }

    protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
        return new SettableBeanPropertyDelegate(d, this.anySetter, this.useAnySetter);
    }

    public void markAsIgnorable() {
        this.delegate.markAsIgnorable();
    }

    public boolean isIgnorable() {
        return this.delegate.isIgnorable();
    }

    public void setViews(Class<?>[] views) {
        this.delegate.setViews((Class[])views);
    }

    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return (A)this.delegate.getContextAnnotation(acls);
    }

    public PropertyName getWrapperName() {
        return this.delegate.getWrapperName();
    }

    public NullValueProvider getNullValueProvider() {
        return this.delegate.getNullValueProvider();
    }

    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        this.delegate.depositSchemaProperty(objectVisitor, provider);
    }

    public JavaType getType() {
        return this.delegate.getType();
    }

    public PropertyName getFullName() {
        return this.delegate.getFullName();
    }

    public void setManagedReferenceName(String n) {
        this.delegate.setManagedReferenceName(n);
    }

    public SettableBeanProperty withSimpleName(String simpleName) {
        return this._with(this.delegate.withSimpleName(simpleName));
    }

    public SettableBeanProperty unwrapped(NameTransformer unwrapper) {
        return this._with(this.delegate.unwrapped(unwrapper));
    }

    public void setObjectIdInfo(ObjectIdInfo objectIdInfo) {
        this.delegate.setObjectIdInfo(objectIdInfo);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            this.delegate.deserializeAndSet(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            if (this.shouldUseAnySetter()) {
                this.anySetter.set(instance, (Object)this.delegate.getName(), (Object)p.getText());
            }
            throw ex;
        }
    }

    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            this.deserializeAndSet(p, ctxt, instance);
            return instance;
        }
    }

    private boolean shouldUseAnySetter() {
        if (this.anySetter == null) {
            return false;
        }
        return this.useAnySetter.getAsBoolean();
    }
}

