/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.BatchJobSubmission;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.KyuubiBatchService;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.server.ui.JettyUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.AuthUtils$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.JavaUtils;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001\u0002\u0015*\u0001IB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tE\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005w!)q\b\u0001C\u0001\u0001\"I!\u0006\u0001a\u0001\u0002\u0004%I\u0001\u0012\u0005\n\u0017\u0002\u0001\r\u00111A\u0005\n1C\u0011\"\u0016\u0001A\u0002\u0003\u0005\u000b\u0015B#\t\u000fY\u0003!\u0019!C\u0005/\"1A\r\u0001Q\u0001\naCQ!\u001a\u0001\u0005\n\u0019Daa\u001c\u0001\u0005\u0002-\u0002\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007{\u0002\u0001\u000b\u0011B=\t\u0013y\u0004\u0001R1A\u0005\u0002-z\bBCA\u0007\u0001!\u0015\r\u0011\"\u0001\u0002\u0010!Q\u0011q\u0005\u0001\t\u0006\u0004%I!!\u000b\t\u0017\u0005E\u0002\u0001#b\u0001\n\u0003Y\u00131\u0007\u0005\u000b\u0003w\u0001\u0001R1A\u0005\n\u0005u\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\ty\u0006\u0001C!\u0003\u001fAq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002f\u0001!I!a\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002d!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u00111\u000e\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002n!9\u00111\u0010\u0001\u0005\n\u0005u\u0004\u0002CAQ\u0001\u0011\u00051&a\u0019\t\u0011\u0005u\u0006\u0001\"\u0001,\u0003\u007fCq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002b\u0002!\t!a\u0019\t\u000f\u0005\r\b\u0001\"\u0011\u0002d!9\u0011Q\u001d\u0001\u0005B\u0005\r\u0004bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003W\u0004A\u0011AAw\u0011\u001d\tY\u000f\u0001C\u0001\u0003gDq!a@\u0001\t\u0003\ty\u0001C\u0004\u0003\u0002\u0001!IAa\u0001\t\u0013\t=\u0001A1A\u0005B\tE\u0001\u0002\u0003B\u000e\u0001\u0001\u0006IAa\u0005\u00033-KX/\u001e2j%\u0016\u001cHO\u0012:p]R,g\u000eZ*feZL7-\u001a\u0006\u0003U-\naa]3sm\u0016\u0014(B\u0001\u0017.\u0003\u0019Y\u00170^;cS*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005YZ\u0013aB:feZL7-Z\u0005\u0003qU\u0012q#\u00112tiJ\f7\r\u001e$s_:$XM\u001c3TKJ4\u0018nY3\u0002\u0015M,'O^3sC\ndW-F\u0001<!\t!D(\u0003\u0002>k\tQ1+\u001a:wKJ\f'\r\\3\u0002\u0017M,'O^3sC\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001b\u0005C\u0001\"\u0001\u001b\u0005I\u0003\"B\u001d\u0004\u0001\u0004YT#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!K\u0013AA;j\u0013\tQuIA\u0006KKR$\u0018pU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011Qj\u0015\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0005+:LG\u000fC\u0004U\u000b\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0013%\u001c8\u000b^1si\u0016$W#\u0001-\u0011\u0005e\u0013W\"\u0001.\u000b\u0005mc\u0016AB1u_6L7M\u0003\u0002^=\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}\u0003\u0017\u0001B;uS2T\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d5\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f!\"[:Ti\u0006\u0014H/\u001a3!\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005G>tgM\u0003\u0002m[\u00051\u0001.\u00193p_BL!A\\5\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00039\u0019Xm]:j_:l\u0015M\\1hKJ,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i.\nqa]3tg&|g.\u0003\u0002wg\n!2*_;vE&\u001cVm]:j_:l\u0015M\\1hKJ\fABY1uG\"\u001c\u0005.Z2lKJ,\u0012!\u001f\t\u0003unl\u0011\u0001X\u0005\u0003yr\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00035\u0011\u0017\r^2i\u0007\",7m[3sA\u0005a!-\u0019;dQN+'O^5dKV\u0011\u0011\u0011\u0001\t\u0006\u001d\u0006\r\u0011qA\u0005\u0004\u0003\u000by%AB(qi&|g\u000eE\u0002C\u0003\u0013I1!a\u0003*\u0005IY\u00150^;cS\n\u000bGo\u00195TKJ4\u0018nY3\u0002\t!|7\u000f^\u000b\u0003\u0003#\u0001B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9bT\u0007\u0003\u00033Q1!a\u00072\u0003\u0019a$o\\8u}%\u0019\u0011qD(\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\tybT\u0001\u0005a>\u0014H/\u0006\u0002\u0002,A\u0019a*!\f\n\u0007\u0005=rJA\u0002J]R\fqb]3dkJLG/_#oC\ndW\rZ\u000b\u0003\u0003k\u00012ATA\u001c\u0013\r\tId\u0014\u0002\b\u0005>|G.Z1o\u00039\tG-\\5oSN$(/\u0019;peN,\"!a\u0010\u0011\r\u0005M\u0011\u0011IA\t\u0013\u0011\t\u0019%!\n\u0003\u0007M+G/A\bjg\u0006#W.\u001b8jgR\u0014\u0018\r^8s)\u0011\t)$!\u0013\t\u000f\u0005-#\u00031\u0001\u0002\u0012\u0005AQo]3s\u001d\u0006lW-\u0001\u0006j]&$\u0018.\u00197ju\u0016$2!TA)\u0011\u0019Q7\u00031\u0001\u0002TA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z-\naaY8oM&<\u0017\u0002BA/\u0003/\u0012!bS=vk\nL7i\u001c8g\u00035\u0019wN\u001c8fGRLwN\\+sY\u0006i1\u000f^1si&sG/\u001a:oC2$\u0012!T\u0001\rS:\u001cH/\u00197m/\u0016\u0014W+S\u0001\u0012gR\f'\u000f\u001e\"bi\u000eD7\t[3dW\u0016\u0014\u0018!\u00052bi\u000eD'+Z2pm\u0016\u0014\u0018\u0010T8dWV\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111\u000f/\u0002\u000b1|7m[:\n\t\u0005]\u0014\u0011\u000f\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002%\t\fGo\u00195SK\u000e|g/\u001a:z\u0019>\u001c7\u000eI\u0001\u001eo&$\bNQ1uG\"\u0014VmY8wKJLHj\\2l%\u0016\fX/\u001b:fIV!\u0011qPAC)\u0011\t\t)a&\u0011\t\u0005\r\u0015Q\u0011\u0007\u0001\t\u001d\t9I\u0007b\u0001\u0003\u0013\u0013\u0011\u0001V\t\u0005\u0003\u0017\u000b\t\nE\u0002O\u0003\u001bK1!a$P\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ATAJ\u0013\r\t)j\u0014\u0002\u0004\u0003:L\b\u0002CAM5\u0011\u0005\r!a'\u0002\u000b\tdwnY6\u0011\u000b9\u000bi*!!\n\u0007\u0005}uJ\u0001\u0005=Eft\u0017-\\3?\u0003Q\u0011XmY8wKJ\u0014\u0015\r^2i'\u0016\u001c8/[8og\"\u001a1$!*\u0011\t\u0005\u001d\u0016\u0011X\u0007\u0003\u0003SSA!a+\u0002.\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\ty+!-\u0002\r\r|W.\\8o\u0015\u0011\t\u0019,!.\u0002\r\u001d|wn\u001a7f\u0015\t\t9,A\u0002d_6LA!a/\u0002*\n\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002AI,7m\u001c<fe\n\u000bGo\u00195TKN\u001c\u0018n\u001c8t\rJ|WNU3bgNLwM\u001c\u000b\u0005\u0003\u0003\f\u0019\u000e\u0005\u0004\u0002D\u00065\u0017\u0011\u0003\b\u0005\u0003\u000b\fIM\u0004\u0003\u0002\u0018\u0005\u001d\u0017\"\u0001)\n\u0007\u0005-w*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0017\u0011\u001b\u0002\u0004'\u0016\f(bAAf\u001f\"9\u0011Q\u001b\u000fA\u0002\u0005\u0005\u0017\u0001\u00032bi\u000eD\u0017\nZ:\u00021\u001d,GOQ1uG\"\u0004VM\u001c3j]\u001el\u0015\r_#mCB\u001cX\r\u0006\u0002\u0002\\B\u0019a*!8\n\u0007\u0005}wJ\u0001\u0003M_:<\u0017\u0001F<bSR4uN]*feZ,'o\u0015;beR,G-A\u0003ti\u0006\u0014H/\u0001\u0003ti>\u0004\u0018aC4fiJ+\u0017\r\\+tKJ$\"!!\u0005\u0002\u001d\u001d,GoU3tg&|g.V:feR!\u0011\u0011CAx\u0011\u001d\t\tP\ta\u0001\u0003#\t\u0011\u0002\u001d:pqf,6/\u001a:\u0015\t\u0005E\u0011Q\u001f\u0005\b\u0003o\u001c\u0003\u0019AA}\u0003-\u0019Xm]:j_:\u001cuN\u001c4\u0011\u0011\u0005M\u00111`A\t\u0003#IA!!@\u0002&\t\u0019Q*\u00199\u0002\u0019\u001d,G/\u00139BI\u0012\u0014Xm]:\u0002\u0019\u001d,G\u000f\u0015:pqf,6/\u001a:\u0015\u0011\u0005E!Q\u0001B\u0004\u0005\u0017Aq!a>&\u0001\u0004\tI\u0010C\u0004\u0003\n\u0015\u0002\r!!\u0005\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\bb\u0002B\u0007K\u0001\u0007\u0011\u0011C\u0001\te\u0016\fG.V:fe\u0006\u0001B-[:d_Z,'/_*feZL7-Z\u000b\u0003\u0005'\u0001RATA\u0002\u0005+\u00012\u0001\u000eB\f\u0013\r\u0011I\"\u000e\u0002\b'\u0016\u0014h/[2f\u0003E!\u0017n]2pm\u0016\u0014\u0018pU3sm&\u001cW\r\t")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private Option<KyuubiBatchService> batchService;
    private String host;
    private int port;
    private boolean securityEnabled;
    private Set<String> administrators;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final ReentrantLock batchRecoveryLock;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private Option<KyuubiBatchService> batchService$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.batchService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_SUBMITTER_ENABLED())) ? new Some((Object)new KyuubiBatchService(this, this.sessionManager())) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.batchService;
    }

    public Option<KyuubiBatchService> batchService() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.batchService$lzycompute();
        }
        return this.batchService;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (JavaUtils.isWindows || JavaUtils.isMac) {
                        this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Kyuubi Server run in Windows or Mac environment, binding ").append(this.getName()).append(" to 0.0.0.0").toString());
                        return "0.0.0.0";
                    }
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return JavaUtils.findLocalInetAddress().getCanonicalHostName();
                    }
                    return JavaUtils.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.host;
    }

    public String host() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    private int port$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.port = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.port;
    }

    private int port() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.port$lzycompute();
        }
        return this.port;
    }

    private boolean securityEnabled$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Seq authTypes = (Seq)((TraversableLike)this.conf().get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
                this.securityEnabled = AuthUtils$.MODULE$.kerberosEnabled(authTypes) || !AuthUtils$.MODULE$.effectivePlainAuthType(authTypes).contains((Object)AuthTypes$.MODULE$.NONE());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.securityEnabled;
    }

    public boolean securityEnabled() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.securityEnabled$lzycompute();
        }
        return this.securityEnabled;
    }

    private Set<String> administrators$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.administrators = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.SERVER_ADMINISTRATORS())).$plus((Object)Utils$.MODULE$.currentUser());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.administrators;
    }

    private Set<String> administrators() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.administrators$lzycompute();
        }
        return this.administrators;
    }

    public boolean isAdministrator(String userName) {
        if (this.securityEnabled()) {
            return this.administrators().contains((Object)userName);
        }
        return true;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), this.port(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS())), BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_JETTY_STOP_TIMEOUT())), BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()))));
        this.batchService().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        Option option = (Option)this.conf().get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_ADVERTISED_HOST());
        if (option instanceof Some) {
            Some some = (Some)option;
            String advertisedHost = (String)some.value();
            return new StringBuilder(1).append(advertisedHost).append(":").append(this.port()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return this.server().getServerUri();
        }
        throw new MatchError((Object)option);
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler, (Option<String>)new Some((Object)"kyuubi.jetty.api.v1")));
        ServletContextHandler proxyHandler = ApiRootResource$.MODULE$.getEngineUIProxyHandler(this);
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)proxyHandler, authenticationFactory.httpHandlerWrapperFactory().wrapHandler$default$2()));
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_UI_ENABLED()))) {
            this.installWebUI();
            return;
        }
    }

    private void installWebUI() {
        this.server().addRedirectHandler("/", "/ui");
        ServletContextHandler servletHandler = JettyUtils$.MODULE$.createStaticHandler("dist", "/ui");
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/");
        servletHandler.setErrorHandler((ErrorHandler)errorHandler);
        this.server().addHandler((Handler)servletHandler);
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSession x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    $this.$outer.sessionManager().getBatchSession(sessionHandle).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSession ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.batchChecker(), task, interval, interval, TimeUnit.MILLISECONDS);
    }

    private ReentrantLock batchRecoveryLock() {
        return this.batchRecoveryLock;
    }

    private <T> T withBatchRecoveryLockRequired(Function0<T> block) {
        Object object;
        this.batchRecoveryLock().lock();
        try {
            object = block.apply();
        }
        finally {
            this.batchRecoveryLock().unlock();
        }
        return (T)object;
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        this.withBatchRecoveryLockRequired((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
            boolean recoveryWaitEngineSubmission = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_WAIT_ENGINE_SUBMISSION()));
            ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
            try {
                Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
                AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
                Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                    Iterable iterable;
                    String batchId = batchSession.batchJobSubmissionOp().batchId();
                    try {
                        Future<Object> task = batchRecoveryExecutor.submit(() -> {
                            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                $this.sessionManager().openBatchSession(batchSession$1);
                                if (recoveryWaitEngineSubmission$1) {
                                    $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Waiting for batch[").append(batchId$1).append("] engine submission during recovery").toString());
                                    BatchJobSubmission batchOp = batchSession$1.batchJobSubmissionOp();
                                    while (batchSession$1.getSessionEvent().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$recoverBatchSessions$6(x$2))) && !batchOp.appStarted() && !OperationState$.MODULE$.isTerminal(batchOp.getStatus().state())) {
                                        Thread.sleep(300L);
                                    }
                                    return;
                                }
                            });
                            return BoxedUnit.UNIT;
                        });
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                    }
                    catch (Throwable e) {
                        this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
                pendingRecoveryTasksCount.addAndGet(tasks.size());
                tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    KyuubiRestFrontendService.$anonfun$recoverBatchSessions$8(this, pendingRecoveryTasksCount, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
            }
        });
    }

    public Seq<String> recoverBatchSessionsFromReassign(Seq<String> batchIds) {
        return (Seq)this.withBatchRecoveryLockRequired((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
            ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-reassign-recovery-executor");
            try {
                Seq finishedBatchIds;
                Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getSpecificBatchSessionsToRecover(batchIds, this.connectionUrl());
                AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
                Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                    Iterable iterable;
                    String batchId = batchSession.batchJobSubmissionOp().batchId();
                    try {
                        Future<Object> task = batchRecoveryExecutor.submit(() -> {
                            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Recovering batch[").append(batchId$3).append("] from reassign").toString());
                                $this.sessionManager().openBatchSession(batchSession$2);
                            });
                            return BoxedUnit.UNIT;
                        });
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                    }
                    catch (Throwable e) {
                        this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
                pendingRecoveryTasksCount.addAndGet(tasks.size());
                seq = finishedBatchIds = (Seq)tasks.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Iterable iterable;
                        Future task = (Future)tuple2._1();
                        String batchId = (String)tuple2._2();
                        try {
                            task.get();
                            int pendingTasks = pendingRecoveryTasksCount.decrementAndGet();
                            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)batchId));
                        }
                        catch (Throwable e) {
                            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                            int pendingTasks = pendingRecoveryTasksCount.decrementAndGet();
                            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                        return iterable;
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
            }
            finally {
                ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
            }
            return seq;
        });
    }

    private long getBatchPendingMaxElapse() {
        Iterable batchPendingElapseTimes = (Iterable)this.sessionManager().allSessions().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)KyuubiRestFrontendService.$anonfun$getBatchPendingMaxElapse$1(x0$1)), Iterable$.MODULE$.canBuildFrom());
        if (batchPendingElapseTimes.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)batchPendingElapseTimes.max((Ordering)Ordering.Long$.MODULE$));
    }

    public void waitForServerStarted() {
        while (!this.server().isStarted()) {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.getName()).append("'s HTTP server getting started").toString());
            Thread.sleep(1000L);
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.startInternal();
                this.waitForServerStarted();
                this.isStarted().set(true);
                this.startBatchChecker();
                this.recoverBatchSessions();
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                    ms.registerGauge(MetricsConstants$.MODULE$.OPERATION_BATCH_PENDING_MAX_ELAPSE(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.getBatchPendingMaxElapse(), (Object)BoxesRunTime.boxToLong((long)0L));
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Exposing REST endpoint at: http://").append(this.server().getServerUri()).toString());
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String proxyUser2) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)proxyUser2).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$4))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.PROXY_USER().key()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.FORBIDDEN);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        String proxyUser;
        block1: {
            if (sessionConf == null) {
                return realUser;
            }
            proxyUser = (String)sessionConf.getOrElse((Object)KyuubiConf$.MODULE$.PROXY_USER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)sessionConf.getOrElse((Object)AuthUtils$.MODULE$.HS2_PROXY_USER(), (Function0 & Serializable & scala.Serializable)() -> realUser));
            if (proxyUser.equals(realUser) || this.isAdministrator(realUser)) break block1;
            AuthUtils$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
        }
        return proxyUser;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ boolean $anonfun$recoverBatchSessions$6(KyuubiSessionEvent x$2) {
        return x$2.exception().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$8(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getBatchPendingMaxElapse$1(Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiBatchSession) {
            KyuubiBatchSession kyuubiBatchSession = (KyuubiBatchSession)session;
            return kyuubiBatchSession.batchJobSubmissionOp().getPendingElapsedTime();
        }
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.batchRecoveryLock = new ReentrantLock();
        this.discoveryService = None$.MODULE$;
    }
}

