/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci.protectedItem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.protectedItem.RestrictedByElem;

public class RestrictedByItem
extends ProtectedItem {
    private final Set<RestrictedByElem> items;

    public RestrictedByItem(Set<RestrictedByElem> items) {
        this.items = Collections.unmodifiableSet(items);
    }

    public Iterator<RestrictedByElem> iterator() {
        return this.items.iterator();
    }

    public int hashCode() {
        int hash = 37;
        if (this.items != null) {
            for (RestrictedByElem item : this.items) {
                if (item != null) {
                    hash *= item.hashCode();
                    continue;
                }
                hash *= 37;
            }
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RestrictedByItem) {
            RestrictedByItem that = (RestrictedByItem)o;
            if (this.items != null) {
                if (that.items == null) {
                    return false;
                }
                if (this.items.size() != that.items.size()) {
                    return false;
                }
                for (RestrictedByElem item : this.items) {
                    if (that.items.contains(item)) continue;
                    return false;
                }
                return true;
            }
            return that.items == null;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("restrictedBy {");
        boolean isFirst = true;
        if (this.items != null) {
            for (RestrictedByElem item : this.items) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(item.toString());
            }
        }
        buf.append('}');
        return buf.toString();
    }
}

