/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.CancelledOperationStatus;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.ops.TimedOutOperationStatus;

public abstract class BaseOperationImpl
extends SpyObject
implements Operation {
    public static final OperationStatus CANCELLED = new CancelledOperationStatus();
    public static final OperationStatus TIMED_OUT = new TimedOutOperationStatus();
    private volatile OperationState state = OperationState.WRITE_QUEUED;
    private ByteBuffer cmd = null;
    private boolean cancelled = false;
    private OperationException exception = null;
    protected OperationCallback callback = null;
    private volatile MemcachedNode handlingNode = null;
    private volatile boolean timedout;
    private long creationTime;
    private boolean timedOutUnsent = false;
    protected Collection<MemcachedNode> notMyVbucketNodes = new HashSet<MemcachedNode>();
    private long writeCompleteTimestamp;
    private List<Operation> clones = Collections.synchronizedList(new ArrayList());
    private volatile int cloneCount;

    public BaseOperationImpl() {
        this.creationTime = System.nanoTime();
    }

    @Override
    public final OperationCallback getCallback() {
        return this.callback;
    }

    protected void setCallback(OperationCallback to) {
        this.callback = to;
    }

    @Override
    public final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean hasErrored() {
        return this.exception != null;
    }

    @Override
    public final OperationException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void cancel() {
        this.cancelled = true;
        List<Operation> list = this.clones;
        synchronized (list) {
            Iterator<Operation> i = this.clones.iterator();
            while (i.hasNext()) {
                i.next().cancel();
            }
        }
        this.wasCancelled();
        this.callback.receivedStatus(CANCELLED);
        this.callback.complete();
    }

    protected void wasCancelled() {
        this.getLogger().debug("was cancelled.");
    }

    @Override
    public final synchronized OperationState getState() {
        return this.state;
    }

    @Override
    public final synchronized ByteBuffer getBuffer() {
        return this.cmd;
    }

    protected final synchronized void setBuffer(ByteBuffer to) {
        assert (to != null) : "Trying to set buffer to null";
        this.cmd = to;
        this.cmd.mark();
    }

    protected final synchronized void transitionState(OperationState newState) {
        this.getLogger().debug("Transitioned state from %s to %s", new Object[]{this.state, newState});
        this.state = newState;
        if (this.state != OperationState.WRITE_QUEUED && this.state != OperationState.WRITING) {
            this.cmd = null;
        }
        if (this.state == OperationState.COMPLETE) {
            this.callback.complete();
        }
    }

    @Override
    public final void writing() {
        this.transitionState(OperationState.WRITING);
    }

    @Override
    public final void writeComplete() {
        this.writeCompleteTimestamp = System.nanoTime();
        this.transitionState(OperationState.READING);
    }

    @Override
    public abstract void initialize();

    @Override
    public abstract void readFromBuffer(ByteBuffer var1) throws IOException;

    protected void handleError(OperationErrorType eType, String line) throws IOException {
        this.getLogger().error("Error:  %s", line);
        switch (eType) {
            case GENERAL: {
                this.exception = new OperationException();
                break;
            }
            case SERVER: {
                this.exception = new OperationException(eType, line);
                break;
            }
            case CLIENT: {
                this.exception = new OperationException(eType, line);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.callback.receivedStatus(new OperationStatus(false, this.exception.getMessage(), StatusCode.ERR_INTERNAL));
        this.transitionState(OperationState.COMPLETE);
        throw this.exception;
    }

    @Override
    public void handleRead(ByteBuffer data) {
        assert (false);
    }

    @Override
    public MemcachedNode getHandlingNode() {
        return this.handlingNode;
    }

    @Override
    public void setHandlingNode(MemcachedNode to) {
        this.handlingNode = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void timeOut() {
        this.timedout = true;
        List<Operation> list = this.clones;
        synchronized (list) {
            Iterator<Operation> i = this.clones.iterator();
            while (i.hasNext()) {
                i.next().timeOut();
            }
        }
        this.callback.receivedStatus(TIMED_OUT);
        this.callback.complete();
    }

    @Override
    public synchronized boolean isTimedOut() {
        return this.timedout;
    }

    @Override
    public synchronized boolean isTimedOut(long ttlMillis) {
        long ttlNanos;
        long elapsed = System.nanoTime();
        if (elapsed - this.creationTime > (ttlNanos = ttlMillis * 1000L * 1000L)) {
            this.timedOutUnsent = true;
            this.timedout = true;
            this.callback.receivedStatus(TIMED_OUT);
            this.callback.complete();
        }
        return this.timedout;
    }

    @Override
    public boolean isTimedOutUnsent() {
        return this.timedOutUnsent;
    }

    @Override
    public long getWriteCompleteTimestamp() {
        return this.writeCompleteTimestamp;
    }

    @Override
    public void addClone(Operation op) {
        this.clones.add(op);
    }

    @Override
    public int getCloneCount() {
        return this.cloneCount;
    }

    @Override
    public void setCloneCount(int count) {
        this.cloneCount = count;
    }
}

