/*
 * Decompiled with CFR 0.152.
 */
package com.papertrail.profiler.jaxrs;

import com.papertrail.profiler.CpuProfile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/pprof")
public class CpuProfileResource {
    private final Lock lock = new ReentrantLock();

    @Produces(value={"pprof/raw"})
    @GET
    @Path(value="profile")
    public byte[] profile(@QueryParam(value="duration") @DefaultValue(value="10") Integer n, @QueryParam(value="frequency") @DefaultValue(value="100") Integer n2) throws IOException {
        return this.doProfile(n, n2, Thread.State.RUNNABLE);
    }

    @Produces(value={"pprof/raw"})
    @GET
    @Path(value="contention")
    public byte[] contention(@QueryParam(value="duration") @DefaultValue(value="10") Integer n, @QueryParam(value="frequency") @DefaultValue(value="100") Integer n2) throws IOException {
        return this.doProfile(n, n2, Thread.State.BLOCKED);
    }

    /*
     * Loose catch block
     */
    protected byte[] doProfile(int n, int n2, Thread.State state) throws IOException {
        if (this.lock.tryLock()) {
            try {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    CpuProfile cpuProfile = CpuProfile.record(Duration.ofSeconds(n), n2, state);
                    if (cpuProfile == null) {
                        throw new RuntimeException("could not create CpuProfile");
                    }
                    cpuProfile.writeGoogleProfile(byteArrayOutputStream);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    return byArray;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new RuntimeException("Only one profile request may be active at a time");
    }
}

