/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.protocol.ascii.AsciiOperationFactory;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.Transcoder;

public class ConnectionFactoryBuilder {
    protected OperationQueueFactory opQueueFactory;
    protected OperationQueueFactory readQueueFactory;
    protected OperationQueueFactory writeQueueFactory;
    protected Transcoder<Object> transcoder;
    protected FailureMode failureMode;
    protected Collection<ConnectionObserver> initialObservers = Collections.emptyList();
    protected OperationFactory opFact;
    protected Locator locator = Locator.ARRAY_MOD;
    protected long opTimeout = -1L;
    protected boolean isDaemon = false;
    protected boolean shouldOptimize = false;
    protected boolean useNagle = false;
    protected long maxReconnectDelay = 30L;
    protected int readBufSize = -1;
    protected HashAlgorithm hashAlg;
    protected AuthDescriptor authDescriptor = null;
    protected long opQueueMaxBlockTime = -1L;
    protected int timeoutExceptionThreshold = 998;
    protected MetricType metricType = null;
    protected MetricCollector collector = null;
    protected ExecutorService executorService = null;
    protected long authWaitTime = 1000L;

    public ConnectionFactoryBuilder() {
    }

    public ConnectionFactoryBuilder(ConnectionFactory cf) {
        this.setAuthDescriptor(cf.getAuthDescriptor());
        this.setDaemon(cf.isDaemon());
        this.setFailureMode(cf.getFailureMode());
        this.setHashAlg(cf.getHashAlg());
        this.setInitialObservers(cf.getInitialObservers());
        this.setMaxReconnectDelay(cf.getMaxReconnectDelay());
        this.setOpQueueMaxBlockTime(cf.getOpQueueMaxBlockTime());
        this.setOpTimeout(cf.getOperationTimeout());
        this.setReadBufferSize(cf.getReadBufSize());
        this.setShouldOptimize(cf.shouldOptimize());
        this.setTimeoutExceptionThreshold(cf.getTimeoutExceptionThreshold());
        this.setTranscoder(cf.getDefaultTranscoder());
        this.setUseNagleAlgorithm(cf.useNagleAlgorithm());
        this.setEnableMetrics(cf.enableMetrics());
        this.setListenerExecutorService(cf.getListenerExecutorService());
        this.setAuthWaitTime(cf.getAuthWaitTime());
    }

    public ConnectionFactoryBuilder setOpQueueFactory(OperationQueueFactory q) {
        this.opQueueFactory = q;
        return this;
    }

    public ConnectionFactoryBuilder setReadOpQueueFactory(OperationQueueFactory q) {
        this.readQueueFactory = q;
        return this;
    }

    public ConnectionFactoryBuilder setWriteOpQueueFactory(OperationQueueFactory q) {
        this.writeQueueFactory = q;
        return this;
    }

    public ConnectionFactoryBuilder setOpQueueMaxBlockTime(long t) {
        this.opQueueMaxBlockTime = t;
        return this;
    }

    public ConnectionFactoryBuilder setTranscoder(Transcoder<Object> t) {
        this.transcoder = t;
        return this;
    }

    public ConnectionFactoryBuilder setFailureMode(FailureMode fm) {
        this.failureMode = fm;
        return this;
    }

    public ConnectionFactoryBuilder setInitialObservers(Collection<ConnectionObserver> obs) {
        this.initialObservers = obs;
        return this;
    }

    public ConnectionFactoryBuilder setOpFact(OperationFactory f) {
        this.opFact = f;
        return this;
    }

    public ConnectionFactoryBuilder setOpTimeout(long t) {
        this.opTimeout = t;
        return this;
    }

    public ConnectionFactoryBuilder setDaemon(boolean d) {
        this.isDaemon = d;
        return this;
    }

    public ConnectionFactoryBuilder setShouldOptimize(boolean o) {
        this.shouldOptimize = o;
        return this;
    }

    public ConnectionFactoryBuilder setReadBufferSize(int to) {
        this.readBufSize = to;
        return this;
    }

    public ConnectionFactoryBuilder setHashAlg(HashAlgorithm to) {
        this.hashAlg = to;
        return this;
    }

    public ConnectionFactoryBuilder setUseNagleAlgorithm(boolean to) {
        this.useNagle = to;
        return this;
    }

    public ConnectionFactoryBuilder setProtocol(Protocol prot) {
        switch (prot) {
            case TEXT: {
                this.opFact = new AsciiOperationFactory();
                break;
            }
            case BINARY: {
                this.opFact = new BinaryOperationFactory();
                break;
            }
            default: {
                assert (false) : "Unhandled protocol: " + (Object)((Object)prot);
                break;
            }
        }
        return this;
    }

    public ConnectionFactoryBuilder setLocatorType(Locator l) {
        this.locator = l;
        return this;
    }

    public ConnectionFactoryBuilder setMaxReconnectDelay(long to) {
        assert (to > 0L) : "Reconnect delay must be a positive number";
        this.maxReconnectDelay = to;
        return this;
    }

    public ConnectionFactoryBuilder setAuthDescriptor(AuthDescriptor to) {
        this.authDescriptor = to;
        return this;
    }

    public ConnectionFactoryBuilder setTimeoutExceptionThreshold(int to) {
        assert (to > 1) : "Minimum timeout exception threshold is 2";
        if (to > 1) {
            this.timeoutExceptionThreshold = to - 2;
        }
        return this;
    }

    public ConnectionFactoryBuilder setEnableMetrics(MetricType type) {
        this.metricType = type;
        return this;
    }

    public ConnectionFactoryBuilder setMetricCollector(MetricCollector collector) {
        this.collector = collector;
        return this;
    }

    public ConnectionFactoryBuilder setListenerExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConnectionFactoryBuilder setAuthWaitTime(long authWaitTime) {
        this.authWaitTime = authWaitTime;
        return this;
    }

    public ConnectionFactory build() {
        return new DefaultConnectionFactory(){

            @Override
            public BlockingQueue<Operation> createOperationQueue() {
                return ConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : ConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            @Override
            public BlockingQueue<Operation> createReadOperationQueue() {
                return ConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : ConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            @Override
            public BlockingQueue<Operation> createWriteOperationQueue() {
                return ConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : ConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            @Override
            public NodeLocator createLocator(List<MemcachedNode> nodes) {
                switch (ConnectionFactoryBuilder.this.locator) {
                    case ARRAY_MOD: {
                        return new ArrayModNodeLocator(nodes, this.getHashAlg());
                    }
                    case CONSISTENT: {
                        return new KetamaNodeLocator(nodes, this.getHashAlg());
                    }
                }
                throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)ConnectionFactoryBuilder.this.locator));
            }

            @Override
            public Transcoder<Object> getDefaultTranscoder() {
                return ConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : ConnectionFactoryBuilder.this.transcoder;
            }

            @Override
            public FailureMode getFailureMode() {
                return ConnectionFactoryBuilder.this.failureMode == null ? super.getFailureMode() : ConnectionFactoryBuilder.this.failureMode;
            }

            @Override
            public HashAlgorithm getHashAlg() {
                return ConnectionFactoryBuilder.this.hashAlg == null ? super.getHashAlg() : ConnectionFactoryBuilder.this.hashAlg;
            }

            @Override
            public Collection<ConnectionObserver> getInitialObservers() {
                return ConnectionFactoryBuilder.this.initialObservers;
            }

            @Override
            public OperationFactory getOperationFactory() {
                return ConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : ConnectionFactoryBuilder.this.opFact;
            }

            @Override
            public long getOperationTimeout() {
                return ConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : ConnectionFactoryBuilder.this.opTimeout;
            }

            @Override
            public int getReadBufSize() {
                return ConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : ConnectionFactoryBuilder.this.readBufSize;
            }

            @Override
            public boolean isDaemon() {
                return ConnectionFactoryBuilder.this.isDaemon;
            }

            @Override
            public boolean shouldOptimize() {
                return ConnectionFactoryBuilder.this.shouldOptimize;
            }

            @Override
            public boolean useNagleAlgorithm() {
                return ConnectionFactoryBuilder.this.useNagle;
            }

            @Override
            public long getMaxReconnectDelay() {
                return ConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            @Override
            public AuthDescriptor getAuthDescriptor() {
                return ConnectionFactoryBuilder.this.authDescriptor;
            }

            @Override
            public long getOpQueueMaxBlockTime() {
                return ConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? ConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            @Override
            public int getTimeoutExceptionThreshold() {
                return ConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            @Override
            public MetricType enableMetrics() {
                return ConnectionFactoryBuilder.this.metricType == null ? super.enableMetrics() : ConnectionFactoryBuilder.this.metricType;
            }

            @Override
            public MetricCollector getMetricCollector() {
                return ConnectionFactoryBuilder.this.collector == null ? super.getMetricCollector() : ConnectionFactoryBuilder.this.collector;
            }

            @Override
            public ExecutorService getListenerExecutorService() {
                return ConnectionFactoryBuilder.this.executorService == null ? super.getListenerExecutorService() : ConnectionFactoryBuilder.this.executorService;
            }

            @Override
            public boolean isDefaultExecutorService() {
                return ConnectionFactoryBuilder.this.executorService == null;
            }

            @Override
            public long getAuthWaitTime() {
                return ConnectionFactoryBuilder.this.authWaitTime;
            }
        };
    }

    public static enum Locator {
        ARRAY_MOD,
        CONSISTENT,
        VBUCKET;

    }

    public static enum Protocol {
        TEXT,
        BINARY;

    }
}

