/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.InputStream;
import java.util.List;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.NodeList;

public final class DomConverterLoader
implements TypeConverterLoader {
    private volatile DomConverter domConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        DomConverterLoader.addTypeConverter(registry, byte[].class, NodeList.class, false, (type, exchange, value) -> this.getDomConverter().toByteArray((NodeList)value, exchange));
        DomConverterLoader.addTypeConverter(registry, InputStream.class, NodeList.class, false, (type, exchange, value) -> this.getDomConverter().toInputStream((NodeList)value, exchange));
        DomConverterLoader.addTypeConverter(registry, Integer.class, NodeList.class, false, (type, exchange, value) -> DomConverter.toInteger((NodeList)value));
        DomConverterLoader.addTypeConverter(registry, Long.class, NodeList.class, false, (type, exchange, value) -> DomConverter.toLong((NodeList)value));
        DomConverterLoader.addTypeConverter(registry, String.class, NodeList.class, false, (type, exchange, value) -> this.getDomConverter().toString((NodeList)value, exchange));
        DomConverterLoader.addTypeConverter(registry, List.class, NodeList.class, false, (type, exchange, value) -> DomConverter.toList((NodeList)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private DomConverter getDomConverter() {
        if (this.domConverter == null) {
            this.domConverter = new DomConverter();
        }
        return this.domConverter;
    }
}

