/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.Strings;
import org.apache.camel.tooling.model.SupportLevel;

public abstract class BaseModel<O extends BaseOptionModel> {
    protected String name;
    protected String title;
    protected String description;
    protected String firstVersion;
    protected String javaType;
    protected String label;
    protected boolean deprecated;
    protected String deprecatedSince;
    protected String deprecationNote;
    protected final List<O> options = new ArrayList<O>();
    protected SupportLevel supportLevel;
    protected boolean nativeSupported;

    public static Comparator<BaseModel<?>> compareTitle() {
        return (m1, m2) -> m1.getTitle().compareToIgnoreCase(m2.getTitle());
    }

    public abstract String getKind();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFirstVersion() {
        return this.firstVersion;
    }

    public void setFirstVersion(String firstVersion) {
        this.firstVersion = firstVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecationNote() {
        return this.deprecationNote;
    }

    public void setDeprecationNote(String deprecationNote) {
        this.deprecationNote = deprecationNote;
    }

    public String getDeprecatedSince() {
        return this.deprecatedSince;
    }

    public void setDeprecatedSince(String deprecatedSince) {
        this.deprecatedSince = deprecatedSince;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public List<O> getOptions() {
        return this.options;
    }

    public void addOption(O option) {
        this.options.add(option);
    }

    public String getShortJavaType() {
        return Strings.getClassShortName(this.javaType);
    }

    public String getFirstVersionShort() {
        return !Strings.isNullOrEmpty(this.firstVersion) ? Strings.cutLastZeroDigit(this.firstVersion) : "";
    }

    public SupportLevel getSupportLevel() {
        return this.supportLevel;
    }

    public void setSupportLevel(SupportLevel supportLevel) {
        this.supportLevel = supportLevel;
    }

    public boolean isNativeSupported() {
        return this.nativeSupported;
    }

    public void setNativeSupported(boolean nativeSupported) {
        this.nativeSupported = nativeSupported;
    }
}

