/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class DropHeaders<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    public static final String OVERVIEW_DOC = "Removes one or more headers from each record.";
    public static final String HEADERS_FIELD = "headers";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("headers", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)false, (boolean)false), ConfigDef.Importance.HIGH, "The name of the headers to be removed.");
    private Set<String> headers;

    public R apply(R record) {
        ConnectHeaders updatedHeaders = new ConnectHeaders();
        for (Header header : record.headers()) {
            if (this.headers.contains(header.key())) continue;
            updatedHeaders.add(header);
        }
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp(), (Iterable)updatedHeaders);
    }

    public String version() {
        return AppInfoParser.getVersion();
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.headers = new HashSet<String>(config.getList(HEADERS_FIELD));
    }
}

