/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;

public class TimeRatio
implements MeasurableStat {
    private long intervalStartTimestampMs = -1L;
    private long lastRecordedTimestampMs = -1L;
    private double totalRecordedDurationMs = 0.0;
    private final double defaultRatio;

    public TimeRatio(double defaultRatio) {
        if (defaultRatio < 0.0 || defaultRatio > 1.0) {
            throw new IllegalArgumentException("Invalid ratio: value " + defaultRatio + " is not between 0 and 1.");
        }
        this.defaultRatio = defaultRatio;
    }

    public double measure(MetricConfig config, long currentTimestampMs) {
        if (this.lastRecordedTimestampMs < 0L) {
            return this.defaultRatio;
        }
        double intervalDurationMs = Math.max(this.lastRecordedTimestampMs - this.intervalStartTimestampMs, 0L);
        double ratio = intervalDurationMs == 0.0 ? this.defaultRatio : (this.totalRecordedDurationMs > intervalDurationMs ? 1.0 : this.totalRecordedDurationMs / intervalDurationMs);
        this.intervalStartTimestampMs = this.lastRecordedTimestampMs;
        this.totalRecordedDurationMs = 0.0;
        return ratio;
    }

    public void record(MetricConfig config, double value, long currentTimestampMs) {
        if (this.intervalStartTimestampMs < 0L) {
            this.intervalStartTimestampMs = currentTimestampMs;
        } else {
            this.totalRecordedDurationMs += value;
            this.lastRecordedTimestampMs = currentTimestampMs;
        }
    }
}

