/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamJoinWindow;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamJoinLeftSide;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamJoinRightSide;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamSelfJoin;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.OuterStreamJoinStoreFactory;
import org.apache.kafka.streams.kstream.internals.PassThrough;
import org.apache.kafka.streams.kstream.internals.StreamJoinedInternal;
import org.apache.kafka.streams.kstream.internals.StreamJoinedStoreFactory;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamStreamJoinNode;
import org.apache.kafka.streams.kstream.internals.graph.WindowedStreamProcessorNode;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StoreBuilderWrapper;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;

class KStreamImplJoin {
    private final InternalStreamsBuilder builder;
    private final boolean leftOuter;
    private final boolean rightOuter;

    KStreamImplJoin(InternalStreamsBuilder builder, boolean leftOuter, boolean rightOuter) {
        this.builder = builder;
        this.leftOuter = leftOuter;
        this.rightOuter = rightOuter;
    }

    public <K, V1, V2, VOut> KStream<K, VOut> join(KStream<K, V1> lhs, KStream<K, V2> other, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VOut> joiner, JoinWindows windows, StreamJoined<K, V1, V2> streamJoined) {
        StreamJoinedStoreFactory<K, V1, V2> otherWindowStore;
        StreamJoinedStoreFactory<K, V1, V2> thisWindowStore;
        StreamJoinedInternal<K, V1, V2> streamJoinedInternal = new StreamJoinedInternal<K, V1, V2>(streamJoined, this.builder);
        NamedInternal renamed = new NamedInternal(streamJoinedInternal.name());
        String joinThisSuffix = this.rightOuter ? "-outer-this-join" : "-this-join";
        String joinOtherSuffix = this.leftOuter ? "-outer-other-join" : "-other-join";
        String thisWindowStreamProcessorName = renamed.suffixWithOrElseGet("-this-windowed", this.builder, "KSTREAM-WINDOWED-");
        String otherWindowStreamProcessorName = renamed.suffixWithOrElseGet("-other-windowed", this.builder, "KSTREAM-WINDOWED-");
        String joinThisGeneratedName = this.rightOuter ? this.builder.newProcessorName("KSTREAM-OUTERTHIS-") : this.builder.newProcessorName("KSTREAM-JOINTHIS-");
        String joinOtherGeneratedName = this.leftOuter ? this.builder.newProcessorName("KSTREAM-OUTEROTHER-") : this.builder.newProcessorName("KSTREAM-JOINOTHER-");
        String joinThisName = renamed.suffixWithOrElseGet(joinThisSuffix, joinThisGeneratedName);
        String joinOtherName = renamed.suffixWithOrElseGet(joinOtherSuffix, joinOtherGeneratedName);
        String joinMergeName = renamed.suffixWithOrElseGet("-merge", this.builder, "KSTREAM-MERGE-");
        GraphNode thisGraphNode = ((AbstractStream)((Object)lhs)).graphNode;
        GraphNode otherGraphNode = ((AbstractStream)((Object)other)).graphNode;
        String userProvidedBaseStoreName = streamJoinedInternal.storeName();
        WindowBytesStoreSupplier thisStoreSupplier = streamJoinedInternal.thisStoreSupplier();
        WindowBytesStoreSupplier otherStoreSupplier = streamJoinedInternal.otherStoreSupplier();
        this.assertUniqueStoreNames(thisStoreSupplier, otherStoreSupplier);
        if (thisStoreSupplier == null) {
            String thisJoinStoreName = userProvidedBaseStoreName == null ? joinThisGeneratedName : userProvidedBaseStoreName + joinThisSuffix;
            thisWindowStore = new StreamJoinedStoreFactory<K, V1, V2>(thisJoinStoreName, windows, streamJoinedInternal, StreamJoinedStoreFactory.Type.THIS);
        } else {
            this.assertWindowSettings(thisStoreSupplier, windows);
            thisWindowStore = KStreamImplJoin.joinWindowStoreBuilderFromSupplier(thisStoreSupplier, streamJoinedInternal.keySerde(), streamJoinedInternal.valueSerde());
        }
        if (otherStoreSupplier == null) {
            String otherJoinStoreName = userProvidedBaseStoreName == null ? joinOtherGeneratedName : userProvidedBaseStoreName + joinOtherSuffix;
            otherWindowStore = new StreamJoinedStoreFactory<K, V1, V2>(otherJoinStoreName, windows, streamJoinedInternal, StreamJoinedStoreFactory.Type.OTHER);
        } else {
            this.assertWindowSettings(otherStoreSupplier, windows);
            otherWindowStore = KStreamImplJoin.joinWindowStoreBuilderFromSupplier(otherStoreSupplier, streamJoinedInternal.keySerde(), streamJoinedInternal.otherValueSerde());
        }
        KStreamJoinWindow thisWindowedStream = new KStreamJoinWindow(thisWindowStore);
        ProcessorParameters thisWindowStreamProcessorParams = new ProcessorParameters(thisWindowedStream, thisWindowStreamProcessorName);
        WindowedStreamProcessorNode thisWindowedStreamsNode = new WindowedStreamProcessorNode(thisWindowStore.storeName(), thisWindowStreamProcessorParams);
        this.builder.addGraphNode(thisGraphNode, thisWindowedStreamsNode);
        KStreamJoinWindow otherWindowedStream = new KStreamJoinWindow(otherWindowStore);
        ProcessorParameters otherWindowStreamProcessorParams = new ProcessorParameters(otherWindowedStream, otherWindowStreamProcessorName);
        WindowedStreamProcessorNode otherWindowedStreamsNode = new WindowedStreamProcessorNode(otherWindowStore.storeName(), otherWindowStreamProcessorParams);
        this.builder.addGraphNode(otherGraphNode, otherWindowedStreamsNode);
        Optional<StoreFactory> outerJoinWindowStore = Optional.empty();
        if (this.leftOuter) {
            outerJoinWindowStore = Optional.of(new OuterStreamJoinStoreFactory<K, V1, V2>(joinThisGeneratedName, streamJoinedInternal, windows, this.rightOuter ? OuterStreamJoinStoreFactory.Type.RIGHT : OuterStreamJoinStoreFactory.Type.LEFT));
        }
        TimeTrackerSupplier sharedTimeTrackerSupplier = new TimeTrackerSupplier();
        JoinWindowsInternal internalWindows = new JoinWindowsInternal(windows);
        KStreamKStreamJoinLeftSide<? super K, ? super V1, ? super V2, ? extends VOut> joinThis = new KStreamKStreamJoinLeftSide<K, V1, V2, VOut>(internalWindows, joiner, this.leftOuter, sharedTimeTrackerSupplier, otherWindowStore, outerJoinWindowStore);
        KStreamKStreamJoinRightSide<? super K, ? super V1, ? super V2, ? extends VOut> joinOther = new KStreamKStreamJoinRightSide<K, V1, V2, VOut>(internalWindows, AbstractStream.reverseJoinerWithKey(joiner), this.rightOuter, sharedTimeTrackerSupplier, thisWindowStore, outerJoinWindowStore);
        KStreamKStreamSelfJoin<? super K, ? super V1, ? super V2, ? extends VOut> selfJoin = new KStreamKStreamSelfJoin<K, V1, V2, VOut>(thisWindowStore, internalWindows, joiner, windows.size() + windows.gracePeriodMs());
        PassThrough joinMerge = new PassThrough();
        StreamStreamJoinNode.StreamStreamJoinNodeBuilder joinBuilder = StreamStreamJoinNode.streamStreamJoinNodeBuilder();
        ProcessorParameters<? super K, ? super V1, ? super V2, ? extends VOut> joinThisProcessorParams = new ProcessorParameters<K, V1, V2, VOut>(joinThis, joinThisName);
        ProcessorParameters<? super K, ? super V1, ? super V2, ? extends VOut> joinOtherProcessorParams = new ProcessorParameters<K, V1, V2, VOut>(joinOther, joinOtherName);
        ProcessorParameters joinMergeProcessorParams = new ProcessorParameters(joinMerge, joinMergeName);
        ProcessorParameters<? super K, ? super V1, ? super V2, ? extends VOut> selfJoinProcessorParams = new ProcessorParameters<K, V1, V2, VOut>(selfJoin, joinMergeName);
        joinBuilder.withJoinMergeProcessorParameters(joinMergeProcessorParams).withJoinThisProcessorParameters(joinThisProcessorParams).withJoinOtherProcessorParameters(joinOtherProcessorParams).withSelfJoinProcessorParameters(selfJoinProcessorParams).withThisWindowedStreamProcessorName(thisWindowStreamProcessorParams.processorName()).withOtherWindowedStreamProcessorName(otherWindowStreamProcessorParams.processorName()).withValueJoiner(joiner).withNodeName(joinMergeName);
        StreamStreamJoinNode joinGraphNode = joinBuilder.build();
        if (this.leftOuter || this.rightOuter) {
            joinGraphNode.addLabel(GraphNode.Label.NULL_KEY_RELAXED_JOIN);
        }
        this.builder.addGraphNode(Arrays.asList(thisGraphNode, otherGraphNode), joinGraphNode);
        HashSet<String> allSourceNodes = new HashSet<String>(((KStreamImpl)lhs).subTopologySourceNodes);
        allSourceNodes.addAll(((KStreamImpl)other).subTopologySourceNodes);
        return new KStreamImpl(joinMergeName, streamJoinedInternal.keySerde(), null, allSourceNodes, false, joinGraphNode, this.builder);
    }

    private void assertWindowSettings(WindowBytesStoreSupplier supplier, JoinWindows joinWindows) {
        boolean allMatch;
        if (!supplier.retainDuplicates()) {
            throw new StreamsException("The StoreSupplier must set retainDuplicates=true, found retainDuplicates=false");
        }
        boolean bl = allMatch = supplier.retentionPeriod() == joinWindows.size() + joinWindows.gracePeriodMs() && supplier.windowSize() == joinWindows.size();
        if (!allMatch) {
            throw new StreamsException(String.format("Window settings mismatch. WindowBytesStoreSupplier settings %s must match JoinWindows settings %s for the window size and retention period", supplier, joinWindows));
        }
    }

    private void assertUniqueStoreNames(WindowBytesStoreSupplier supplier, WindowBytesStoreSupplier otherSupplier) {
        if (supplier != null && otherSupplier != null && supplier.name().equals(otherSupplier.name())) {
            throw new StreamsException("Both StoreSuppliers have the same name.  StoreSuppliers must provide unique names");
        }
    }

    private static <K, V> StoreFactory joinWindowStoreBuilderFromSupplier(WindowBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde) {
        return StoreBuilderWrapper.wrapStoreBuilder(Stores.windowStoreBuilder(storeSupplier, keySerde, valueSerde));
    }

    static class TimeTrackerSupplier {
        private final Map<TaskId, TimeTracker> tracker = new ConcurrentHashMap<TaskId, TimeTracker>();

        TimeTrackerSupplier() {
        }

        public TimeTracker get(TaskId taskId) {
            return this.tracker.computeIfAbsent(taskId, taskId1 -> new TimeTracker());
        }

        public void remove(TaskId taskId) {
            this.tracker.remove(taskId);
        }
    }

    static class TimeTracker {
        private long emitIntervalMs = 1000L;
        long streamTime = -1L;
        long minTime = Long.MAX_VALUE;
        long nextTimeToEmit;

        TimeTracker() {
        }

        public void setEmitInterval(long emitIntervalMs) {
            this.emitIntervalMs = emitIntervalMs;
        }

        public void advanceStreamTime(long recordTimestamp) {
            this.streamTime = Math.max(recordTimestamp, this.streamTime);
        }

        public void updatedMinTime(long recordTimestamp) {
            this.minTime = Math.min(recordTimestamp, this.minTime);
        }

        public void advanceNextTimeToEmit() {
            this.nextTimeToEmit += this.emitIntervalMs;
        }
    }
}

