/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.security.scram.ScramCredential;

public final class ScramCredentialData {
    private final byte[] salt;
    private final byte[] storedKey;
    private final byte[] serverKey;
    private final int iterations;

    public static ScramCredentialData fromRecord(UserScramCredentialRecord record) {
        return new ScramCredentialData(record.salt(), record.storedKey(), record.serverKey(), record.iterations());
    }

    public ScramCredentialData(byte[] salt, byte[] storedKey, byte[] serverKey, int iterations) {
        this.salt = salt;
        this.storedKey = storedKey;
        this.serverKey = serverKey;
        this.iterations = iterations;
    }

    public byte[] salt() {
        return this.salt;
    }

    public byte[] storedKey() {
        return this.storedKey;
    }

    public byte[] serverKey() {
        return this.serverKey;
    }

    public int iterations() {
        return this.iterations;
    }

    public UserScramCredentialRecord toRecord(String userName, ScramMechanism mechanism) {
        return new UserScramCredentialRecord().setName(userName).setMechanism(mechanism.type()).setSalt(this.salt).setStoredKey(this.storedKey).setServerKey(this.serverKey).setIterations(this.iterations);
    }

    public ScramCredential toCredential(ScramMechanism mechanism) {
        return new ScramCredential(this.salt, this.storedKey, this.serverKey, this.iterations);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.salt), Arrays.hashCode(this.storedKey), Arrays.hashCode(this.serverKey), this.iterations);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(ScramCredentialData.class)) {
            return false;
        }
        ScramCredentialData other = (ScramCredentialData)o;
        return Arrays.equals(this.salt, other.salt) && Arrays.equals(this.storedKey, other.storedKey) && Arrays.equals(this.serverKey, other.serverKey) && this.iterations == other.iterations;
    }

    public String toString() {
        return "ScramCredentialData(salt=[hidden], storedKey=[hidden], serverKey=[hidden], iterations=[hidden])";
    }
}

