/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class PluginDesc<T>
implements Comparable<PluginDesc<?>> {
    public static final String UNDEFINED_VERSION = "undefined";
    private final Class<? extends T> klass;
    private final String name;
    private final String version;
    private final DefaultArtifactVersion encodedVersion;
    private final PluginType type;
    private final String typeName;
    private final String location;
    private final ClassLoader loader;

    public PluginDesc(Class<? extends T> klass, String version, PluginType type, ClassLoader loader) {
        this.klass = Objects.requireNonNull(klass, "Plugin class must be non-null");
        this.name = this.klass.getName();
        this.version = version != null ? version : "null";
        this.encodedVersion = new DefaultArtifactVersion(this.version);
        this.type = Objects.requireNonNull(type, "Plugin type must be non-null");
        this.typeName = this.type.toString();
        Objects.requireNonNull(loader, "Plugin classloader must be non-null");
        this.location = loader instanceof PluginClassLoader ? Objects.requireNonNull(((PluginClassLoader)loader).location(), "Plugin location must be non-null") : "classpath";
        this.loader = loader;
    }

    public String toString() {
        return "PluginDesc{klass=" + String.valueOf(this.klass) + ", name='" + this.name + "', version='" + this.version + "', encodedVersion=" + String.valueOf(this.encodedVersion) + ", type=" + String.valueOf((Object)this.type) + ", typeName='" + this.typeName + "', location='" + this.location + "'}";
    }

    public Class<? extends T> pluginClass() {
        return this.klass;
    }

    @JsonProperty(value="class")
    public String className() {
        return this.name;
    }

    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public PluginType type() {
        return this.type;
    }

    @JsonProperty(value="type")
    public String typeName() {
        return this.typeName;
    }

    @JsonProperty(value="location")
    public String location() {
        return this.location;
    }

    public ClassLoader loader() {
        return this.loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginDesc)) {
            return false;
        }
        PluginDesc that = (PluginDesc)o;
        return Objects.equals(this.klass, that.klass) && Objects.equals(this.version, that.version) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.klass, this.version, this.type});
    }

    @Override
    public int compareTo(PluginDesc<?> other) {
        int nameComp = this.name.compareTo(other.name);
        int versionComp = this.encodedVersion.compareTo((ArtifactVersion)other.encodedVersion);
        int isolatedComp = Boolean.compare(other.loader instanceof PluginClassLoader, this.loader instanceof PluginClassLoader);
        int loaderComp = this.location.compareTo(other.location);
        int typeComp = this.type.compareTo(other.type);
        return nameComp != 0 ? nameComp : (versionComp != 0 ? versionComp : (isolatedComp != 0 ? isolatedComp : (loaderComp != 0 ? loaderComp : typeComp)));
    }
}

