/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.NodeMap;
import org.locationtech.jts.planargraph.PlanarGraph;

public class Subgraph {
    protected PlanarGraph parentGraph;
    protected Set edges = new HashSet();
    protected List dirEdges = new ArrayList();
    protected NodeMap nodeMap = new NodeMap();

    public Subgraph(PlanarGraph parentGraph) {
        this.parentGraph = parentGraph;
    }

    public PlanarGraph getParent() {
        return this.parentGraph;
    }

    public void add(Edge e2) {
        if (this.edges.contains(e2)) {
            return;
        }
        this.edges.add(e2);
        this.dirEdges.add(e2.getDirEdge(0));
        this.dirEdges.add(e2.getDirEdge(1));
        this.nodeMap.add(e2.getDirEdge(0).getFromNode());
        this.nodeMap.add(e2.getDirEdge(1).getFromNode());
    }

    public Iterator dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    public Iterator edgeIterator() {
        return this.edges.iterator();
    }

    public Iterator nodeIterator() {
        return this.nodeMap.iterator();
    }

    public boolean contains(Edge e2) {
        return this.edges.contains(e2);
    }
}

