/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import java.util.Objects;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTP;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTPBuilder;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateProcessorStreaming;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.update.UpdateStreaming;

public class UpdateExecutionFactory {
    public static UpdateExecution create(Update update2, Dataset dataset) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), dataset);
    }

    public static UpdateExecution create(UpdateRequest updateRequest, Dataset dataset) {
        return UpdateExecutionFactory.make(updateRequest, dataset, null);
    }

    public static UpdateExecution create(UpdateRequest updateRequest, Dataset dataset, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, dataset, context2);
    }

    private static UpdateExecution make(UpdateRequest updateRequest, Dataset dataset, Context context2) {
        return UpdateExecution.dataset(dataset).update(updateRequest).build();
    }

    @Deprecated(forRemoval=true)
    public static UpdateProcessorStreaming createStreaming(Dataset dataset) {
        return UpdateStreaming.makeStreaming(dataset.asDatasetGraph(), null, null);
    }

    public static UpdateExecution createRemote(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemote(new UpdateRequest(update2), remoteEndpoint, UpdateSendMode.asPost);
    }

    public static UpdateExecution createRemote(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemote(updateRequest, remoteEndpoint, UpdateSendMode.asPost);
    }

    public static UpdateExecution createRemoteForm(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemote(new UpdateRequest(update2), remoteEndpoint, UpdateSendMode.asPostForm);
    }

    public static UpdateExecution createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemote(updateRequest, remoteEndpoint, UpdateSendMode.asPostForm);
    }

    private static UpdateExecution makeRemote(UpdateRequest updateRequest, String remoteEndpoint, UpdateSendMode updateSendMode) {
        Objects.requireNonNull(updateRequest, "updateRequest");
        Objects.requireNonNull(remoteEndpoint, "remoteEndpoint");
        Objects.requireNonNull(updateSendMode, "updateSendMode");
        return (UpdateExecution)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)UpdateExecutionHTTP.create().endpoint(remoteEndpoint)).update(updateRequest)).sendMode(updateSendMode)).build();
    }
}

