/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.SortedDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.cdt.CDTFactory;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.ExprUtils;

public class AggFoldMap
extends AggregatorBase {
    protected final Expr expr1;
    protected final Expr expr2;
    protected final List<SortCondition> orderBy;
    protected final ThresholdPolicy<Binding> policy;
    protected final Comparator<Binding> comparator;

    public AggFoldMap(Expr expr1, Expr expr2) {
        this(expr1, expr2, null);
    }

    public AggFoldMap(Expr expr1, Expr expr2, List<SortCondition> orderBy) {
        super("FOLD", false, AggFoldMap.collectExprs(expr1, expr2, orderBy));
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.orderBy = orderBy;
        if (orderBy != null && !orderBy.isEmpty()) {
            this.policy = ThresholdPolicyFactory.policyFromContext(ARQ.getContext());
            this.comparator = new BindingComparator(orderBy);
        } else {
            this.policy = null;
            this.comparator = null;
        }
    }

    protected static ExprList collectExprs(Expr expr1, Expr expr2, List<SortCondition> orderBy) {
        ExprList l = new ExprList();
        l.add(expr1);
        l.add(expr2);
        if (orderBy != null) {
            for (SortCondition c : orderBy) {
                l.add(c.getExpression());
            }
        }
        return l;
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        ArrayList<SortCondition> _orderBy;
        Expr _expr2;
        Expr _expr1;
        if (this.orderBy == null) {
            if (exprs.size() != 2) {
                throw new IllegalArgumentException();
            }
            _expr1 = exprs.get(0);
            _expr2 = exprs.get(1);
            _orderBy = null;
        } else {
            if (exprs.size() != this.orderBy.size() + 2) {
                throw new IllegalArgumentException();
            }
            Iterator<SortCondition> cit = this.orderBy.iterator();
            Iterator<Expr> eit = exprs.iterator();
            _expr1 = eit.next();
            _expr2 = eit.next();
            _orderBy = new ArrayList<SortCondition>(this.orderBy.size());
            while (eit.hasNext()) {
                SortCondition c = new SortCondition(eit.next(), cit.next().getDirection());
                _orderBy.add(c);
            }
        }
        return new AggFoldMap(_expr1, _expr2, _orderBy);
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggFoldMap)) {
            return false;
        }
        AggFoldMap fold = (AggFoldMap)other;
        return this.exprList.equals(fold.exprList, bySyntax) && Objects.equals(this.orderBy, fold.orderBy);
    }

    @Override
    public Accumulator createAccumulator() {
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            return new SortingMapAccumulator();
        }
        return new BasicMapAccumulator();
    }

    @Override
    public Node getValueEmpty() {
        HashMap<CDTKey, CDTValue> emptyMap = new HashMap<CDTKey, CDTValue>();
        return CDTLiteralFunctionUtils.createNode(emptyMap);
    }

    @Override
    public int hashCode() {
        int hc = 391;
        hc ^= this.getExprList().get(0).hashCode();
        return hc ^= this.getExprList().get(1).hashCode();
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.append(this.getName(), new Object[0]);
        out.append("(", new Object[0]);
        ExprUtils.fmtSPARQL((IndentedWriter)out, this.expr1, sCxt);
        out.append(", ", new Object[0]);
        ExprUtils.fmtSPARQL((IndentedWriter)out, this.expr2, sCxt);
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            out.append(" ORDER BY ", new Object[0]);
            Iterator<SortCondition> it = this.orderBy.iterator();
            while (it.hasNext()) {
                it.next().output(out, sCxt);
                if (!it.hasNext()) continue;
                out.append(", ", new Object[0]);
            }
        }
        out.append(")", new Object[0]);
        return out.asString();
    }

    @Override
    public String toPrefixString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.append("(", new Object[0]);
        out.append(this.getName().toLowerCase(Locale.ROOT), new Object[0]);
        out.incIndent();
        WriterExpr.output((IndentedWriter)out, this.expr1, null);
        out.append(", ", new Object[0]);
        WriterExpr.output((IndentedWriter)out, this.expr2, null);
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            out.append(" order by ", new Object[0]);
            out.incIndent();
            for (SortCondition c : this.orderBy) {
                c.output(out);
            }
            out.decIndent();
        }
        out.decIndent();
        out.append(")", new Object[0]);
        return out.asString();
    }

    protected class SortingMapAccumulator
    implements Accumulator {
        protected final SortedDataBag<Binding> sbag;
        protected FunctionEnv functionEnv = null;

        public SortingMapAccumulator() {
            SerializationFactory<Binding> sf = SerializationFactoryFinder.bindingSerializationFactory();
            this.sbag = BagFactory.newSortedBag(AggFoldMap.this.policy, sf, AggFoldMap.this.comparator);
        }

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            this.sbag.add(binding);
            if (this.functionEnv == null) {
                this.functionEnv = functionEnv;
            }
        }

        @Override
        public NodeValue getValue() {
            Iterator<Binding> it = this.sbag.iterator();
            BasicMapAccumulator acc = new BasicMapAccumulator();
            while (it.hasNext()) {
                acc.accumulate(it.next(), this.functionEnv);
            }
            this.sbag.close();
            return acc.getValue();
        }
    }

    protected class BasicMapAccumulator
    implements Accumulator {
        protected final Map<CDTKey, CDTValue> map = new HashMap<CDTKey, CDTValue>();

        protected BasicMapAccumulator() {
        }

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            NodeValue nvKey = ExprLib.evalOrNull(AggFoldMap.this.expr1, binding, functionEnv);
            if (nvKey == null) {
                return;
            }
            if (nvKey.isBlank()) {
                return;
            }
            CDTKey key = CDTFactory.createKey(nvKey.asNode());
            NodeValue nvValue = ExprLib.evalOrNull(AggFoldMap.this.expr2, binding, functionEnv);
            CDTValue value = nvValue == null ? CDTFactory.getNullValue() : CDTFactory.createValue(nvValue.asNode());
            this.map.put(key, value);
        }

        @Override
        public NodeValue getValue() {
            return CDTLiteralFunctionUtils.createNodeValue(this.map);
        }
    }
}

